/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceClient;
import software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersResponse;

public class ListPhoneNumberOrdersIterable
implements SdkIterable<ListPhoneNumberOrdersResponse> {
    private final ChimeSdkVoiceClient client;
    private final ListPhoneNumberOrdersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPhoneNumberOrdersIterable(ChimeSdkVoiceClient client, ListPhoneNumberOrdersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPhoneNumberOrdersResponseFetcher();
    }

    public Iterator<ListPhoneNumberOrdersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPhoneNumberOrdersResponseFetcher
    implements SyncPageFetcher<ListPhoneNumberOrdersResponse> {
        private ListPhoneNumberOrdersResponseFetcher() {
        }

        public boolean hasNextPage(ListPhoneNumberOrdersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPhoneNumberOrdersResponse nextPage(ListPhoneNumberOrdersResponse previousPage) {
            if (previousPage == null) {
                return ListPhoneNumberOrdersIterable.this.client.listPhoneNumberOrders(ListPhoneNumberOrdersIterable.this.firstRequest);
            }
            return ListPhoneNumberOrdersIterable.this.client.listPhoneNumberOrders((ListPhoneNumberOrdersRequest)((Object)ListPhoneNumberOrdersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

