/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceClient;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplication;

public class ListSipMediaApplicationsIterable
implements SdkIterable<ListSipMediaApplicationsResponse> {
    private final ChimeSdkVoiceClient client;
    private final ListSipMediaApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSipMediaApplicationsIterable(ChimeSdkVoiceClient client, ListSipMediaApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSipMediaApplicationsResponseFetcher();
    }

    public Iterator<ListSipMediaApplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SipMediaApplication> sipMediaApplications() {
        Function<ListSipMediaApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sipMediaApplications() != null) {
                return response.sipMediaApplications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSipMediaApplicationsResponseFetcher
    implements SyncPageFetcher<ListSipMediaApplicationsResponse> {
        private ListSipMediaApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSipMediaApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSipMediaApplicationsResponse nextPage(ListSipMediaApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListSipMediaApplicationsIterable.this.client.listSipMediaApplications(ListSipMediaApplicationsIterable.this.firstRequest);
            }
            return ListSipMediaApplicationsIterable.this.client.listSipMediaApplications((ListSipMediaApplicationsRequest)((Object)ListSipMediaApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

