/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceAsyncClient;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.SipRule;

public class ListSipRulesPublisher
implements SdkPublisher<ListSipRulesResponse> {
    private final ChimeSdkVoiceAsyncClient client;
    private final ListSipRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSipRulesPublisher(ChimeSdkVoiceAsyncClient client, ListSipRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSipRulesPublisher(ChimeSdkVoiceAsyncClient client, ListSipRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSipRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSipRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SipRule> sipRules() {
        Function<ListSipRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sipRules() != null) {
                return response.sipRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSipRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSipRulesResponseFetcher
    implements AsyncPageFetcher<ListSipRulesResponse> {
        private ListSipRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListSipRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSipRulesResponse> nextPage(ListSipRulesResponse previousPage) {
            if (previousPage == null) {
                return ListSipRulesPublisher.this.client.listSipRules(ListSipRulesPublisher.this.firstRequest);
            }
            return ListSipRulesPublisher.this.client.listSipRules((ListSipRulesRequest)((Object)ListSipRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

