/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmessaging.model.Processor;
import software.amazon.awssdk.services.chimesdkmessaging.model.ProcessorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelFlowSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelFlowSummary> {
    private static final SdkField<String> CHANNEL_FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelFlowArn").getter(ChannelFlowSummary.getter(ChannelFlowSummary::channelFlowArn)).setter(ChannelFlowSummary.setter(Builder::channelFlowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelFlowArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ChannelFlowSummary.getter(ChannelFlowSummary::name)).setter(ChannelFlowSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<Processor>> PROCESSORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Processors").getter(ChannelFlowSummary.getter(ChannelFlowSummary::processors)).setter(ChannelFlowSummary.setter(Builder::processors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Processor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FLOW_ARN_FIELD, NAME_FIELD, PROCESSORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChannelFlowSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String channelFlowArn;
    private final String name;
    private final List<Processor> processors;

    private ChannelFlowSummary(BuilderImpl builder) {
        this.channelFlowArn = builder.channelFlowArn;
        this.name = builder.name;
        this.processors = builder.processors;
    }

    public final String channelFlowArn() {
        return this.channelFlowArn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasProcessors() {
        return this.processors != null && !(this.processors instanceof SdkAutoConstructList);
    }

    public final List<Processor> processors() {
        return this.processors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelFlowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessors() ? this.processors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelFlowSummary)) {
            return false;
        }
        ChannelFlowSummary other = (ChannelFlowSummary)obj;
        return Objects.equals(this.channelFlowArn(), other.channelFlowArn()) && Objects.equals(this.name(), other.name()) && this.hasProcessors() == other.hasProcessors() && Objects.equals(this.processors(), other.processors());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelFlowSummary").add("ChannelFlowArn", (Object)this.channelFlowArn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Processors", this.hasProcessors() ? this.processors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelFlowArn": {
                return Optional.ofNullable(clazz.cast(this.channelFlowArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Processors": {
                return Optional.ofNullable(clazz.cast(this.processors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelFlowArn", CHANNEL_FLOW_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Processors", PROCESSORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelFlowSummary, T> g) {
        return obj -> g.apply((ChannelFlowSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelFlowArn;
        private String name;
        private List<Processor> processors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelFlowSummary model) {
            this.channelFlowArn(model.channelFlowArn);
            this.name(model.name);
            this.processors(model.processors);
        }

        public final String getChannelFlowArn() {
            return this.channelFlowArn;
        }

        public final void setChannelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
        }

        @Override
        public final Builder channelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Processor.Builder> getProcessors() {
            List<Processor.Builder> result = ProcessorListCopier.copyToBuilder(this.processors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessors(Collection<Processor.BuilderImpl> processors) {
            this.processors = ProcessorListCopier.copyFromBuilder(processors);
        }

        @Override
        public final Builder processors(Collection<Processor> processors) {
            this.processors = ProcessorListCopier.copy(processors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Processor ... processors) {
            this.processors(Arrays.asList(processors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Consumer<Processor.Builder> ... processors) {
            this.processors(Stream.of(processors).map(c -> (Processor)((Processor.Builder)Processor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ChannelFlowSummary build() {
            return new ChannelFlowSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelFlowSummary> {
        public Builder channelFlowArn(String var1);

        public Builder name(String var1);

        public Builder processors(Collection<Processor> var1);

        public Builder processors(Processor ... var1);

        public Builder processors(Consumer<Processor.Builder> ... var1);
    }
}

