/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateChannelMessageRequest
extends ChimeSdkMessagingRequest
implements ToCopyableBuilder<Builder, UpdateChannelMessageRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(UpdateChannelMessageRequest.getter(UpdateChannelMessageRequest::channelArn)).setter(UpdateChannelMessageRequest.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()}).build();
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(UpdateChannelMessageRequest.getter(UpdateChannelMessageRequest::messageId)).setter(UpdateChannelMessageRequest.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("messageId").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(UpdateChannelMessageRequest.getter(UpdateChannelMessageRequest::content)).setter(UpdateChannelMessageRequest.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metadata").getter(UpdateChannelMessageRequest.getter(UpdateChannelMessageRequest::metadata)).setter(UpdateChannelMessageRequest.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChimeBearer").getter(UpdateChannelMessageRequest.getter(UpdateChannelMessageRequest::chimeBearer)).setter(UpdateChannelMessageRequest.setter(Builder::chimeBearer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()}).build();
    private static final SdkField<String> SUB_CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubChannelId").getter(UpdateChannelMessageRequest.getter(UpdateChannelMessageRequest::subChannelId)).setter(UpdateChannelMessageRequest.setter(Builder::subChannelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubChannelId").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(UpdateChannelMessageRequest.getter(UpdateChannelMessageRequest::contentType)).setter(UpdateChannelMessageRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, MESSAGE_ID_FIELD, CONTENT_FIELD, METADATA_FIELD, CHIME_BEARER_FIELD, SUB_CHANNEL_ID_FIELD, CONTENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateChannelMessageRequest.memberNameToFieldInitializer();
    private final String channelArn;
    private final String messageId;
    private final String content;
    private final String metadata;
    private final String chimeBearer;
    private final String subChannelId;
    private final String contentType;

    private UpdateChannelMessageRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.messageId = builder.messageId;
        this.content = builder.content;
        this.metadata = builder.metadata;
        this.chimeBearer = builder.chimeBearer;
        this.subChannelId = builder.subChannelId;
        this.contentType = builder.contentType;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final String content() {
        return this.content;
    }

    public final String metadata() {
        return this.metadata;
    }

    public final String chimeBearer() {
        return this.chimeBearer;
    }

    public final String subChannelId() {
        return this.subChannelId;
    }

    public final String contentType() {
        return this.contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.chimeBearer());
        hashCode = 31 * hashCode + Objects.hashCode(this.subChannelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelMessageRequest)) {
            return false;
        }
        UpdateChannelMessageRequest other = (UpdateChannelMessageRequest)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.chimeBearer(), other.chimeBearer()) && Objects.equals(this.subChannelId(), other.subChannelId()) && Objects.equals(this.contentType(), other.contentType());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateChannelMessageRequest").add("ChannelArn", (Object)this.channelArn()).add("MessageId", (Object)this.messageId()).add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).add("Metadata", (Object)(this.metadata() == null ? null : "*** Sensitive Data Redacted ***")).add("ChimeBearer", (Object)this.chimeBearer()).add("SubChannelId", (Object)this.subChannelId()).add("ContentType", (Object)(this.contentType() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "ChimeBearer": {
                return Optional.ofNullable(clazz.cast(this.chimeBearer()));
            }
            case "SubChannelId": {
                return Optional.ofNullable(clazz.cast(this.subChannelId()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("channelArn", CHANNEL_ARN_FIELD);
        map.put("messageId", MESSAGE_ID_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("x-amz-chime-bearer", CHIME_BEARER_FIELD);
        map.put("SubChannelId", SUB_CHANNEL_ID_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelMessageRequest, T> g) {
        return obj -> g.apply((UpdateChannelMessageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingRequest.BuilderImpl
    implements Builder {
        private String channelArn;
        private String messageId;
        private String content;
        private String metadata;
        private String chimeBearer;
        private String subChannelId;
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelMessageRequest model) {
            super(model);
            this.channelArn(model.channelArn);
            this.messageId(model.messageId);
            this.content(model.content);
            this.metadata(model.metadata);
            this.chimeBearer(model.chimeBearer);
            this.subChannelId(model.subChannelId);
            this.contentType(model.contentType);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getChimeBearer() {
            return this.chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        public final String getSubChannelId() {
            return this.subChannelId;
        }

        public final void setSubChannelId(String subChannelId) {
            this.subChannelId = subChannelId;
        }

        @Override
        public final Builder subChannelId(String subChannelId) {
            this.subChannelId = subChannelId;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelMessageRequest build() {
            return new UpdateChannelMessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkMessagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateChannelMessageRequest> {
        public Builder channelArn(String var1);

        public Builder messageId(String var1);

        public Builder content(String var1);

        public Builder metadata(String var1);

        public Builder chimeBearer(String var1);

        public Builder subChannelId(String var1);

        public Builder contentType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

