/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AllowNotifications {
    ALL("ALL"),
    NONE("NONE"),
    FILTERED("FILTERED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AllowNotifications> VALUE_MAP;
    private final String value;

    private AllowNotifications(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AllowNotifications fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AllowNotifications> knownValues() {
        EnumSet<AllowNotifications> knownValues = EnumSet.allOf(AllowNotifications.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AllowNotifications.class, AllowNotifications::toString);
    }
}

