/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipPreferences;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingResponse;
import software.amazon.awssdk.services.chimesdkmessaging.model.Identity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutChannelMembershipPreferencesResponse
extends ChimeSdkMessagingResponse
implements ToCopyableBuilder<Builder, PutChannelMembershipPreferencesResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(PutChannelMembershipPreferencesResponse.getter(PutChannelMembershipPreferencesResponse::channelArn)).setter(PutChannelMembershipPreferencesResponse.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final SdkField<Identity> MEMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Member").getter(PutChannelMembershipPreferencesResponse.getter(PutChannelMembershipPreferencesResponse::member)).setter(PutChannelMembershipPreferencesResponse.setter(Builder::member)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Member").build()}).build();
    private static final SdkField<ChannelMembershipPreferences> PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Preferences").getter(PutChannelMembershipPreferencesResponse.getter(PutChannelMembershipPreferencesResponse::preferences)).setter(PutChannelMembershipPreferencesResponse.setter(Builder::preferences)).constructor(ChannelMembershipPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preferences").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, MEMBER_FIELD, PREFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ChannelArn", CHANNEL_ARN_FIELD);
            this.put("Member", MEMBER_FIELD);
            this.put("Preferences", PREFERENCES_FIELD);
        }
    });
    private final String channelArn;
    private final Identity member;
    private final ChannelMembershipPreferences preferences;

    private PutChannelMembershipPreferencesResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.member = builder.member;
        this.preferences = builder.preferences;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final Identity member() {
        return this.member;
    }

    public final ChannelMembershipPreferences preferences() {
        return this.preferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.member());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferences());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutChannelMembershipPreferencesResponse)) {
            return false;
        }
        PutChannelMembershipPreferencesResponse other = (PutChannelMembershipPreferencesResponse)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.member(), other.member()) && Objects.equals(this.preferences(), other.preferences());
    }

    public final String toString() {
        return ToString.builder((String)"PutChannelMembershipPreferencesResponse").add("ChannelArn", (Object)this.channelArn()).add("Member", (Object)this.member()).add("Preferences", (Object)this.preferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "Member": {
                return Optional.ofNullable(clazz.cast(this.member()));
            }
            case "Preferences": {
                return Optional.ofNullable(clazz.cast(this.preferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutChannelMembershipPreferencesResponse, T> g) {
        return obj -> g.apply((PutChannelMembershipPreferencesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingResponse.BuilderImpl
    implements Builder {
        private String channelArn;
        private Identity member;
        private ChannelMembershipPreferences preferences;

        private BuilderImpl() {
        }

        private BuilderImpl(PutChannelMembershipPreferencesResponse model) {
            super(model);
            this.channelArn(model.channelArn);
            this.member(model.member);
            this.preferences(model.preferences);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final Identity.Builder getMember() {
            return this.member != null ? this.member.toBuilder() : null;
        }

        public final void setMember(Identity.BuilderImpl member) {
            this.member = member != null ? member.build() : null;
        }

        @Override
        public final Builder member(Identity member) {
            this.member = member;
            return this;
        }

        public final ChannelMembershipPreferences.Builder getPreferences() {
            return this.preferences != null ? this.preferences.toBuilder() : null;
        }

        public final void setPreferences(ChannelMembershipPreferences.BuilderImpl preferences) {
            this.preferences = preferences != null ? preferences.build() : null;
        }

        @Override
        public final Builder preferences(ChannelMembershipPreferences preferences) {
            this.preferences = preferences;
            return this;
        }

        @Override
        public PutChannelMembershipPreferencesResponse build() {
            return new PutChannelMembershipPreferencesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkMessagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutChannelMembershipPreferencesResponse> {
        public Builder channelArn(String var1);

        public Builder member(Identity var1);

        default public Builder member(Consumer<Identity.Builder> member) {
            return this.member((Identity)((Identity.Builder)Identity.builder().applyMutation(member)).build());
        }

        public Builder preferences(ChannelMembershipPreferences var1);

        default public Builder preferences(Consumer<ChannelMembershipPreferences.Builder> preferences) {
            return this.preferences((ChannelMembershipPreferences)((ChannelMembershipPreferences.Builder)ChannelMembershipPreferences.builder().applyMutation(preferences)).build());
        }
    }
}

