/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmessaging.ChimeSdkMessagingClient;
import software.amazon.awssdk.services.chimesdkmessaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMessagesRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMessagesResponse;

public class ListChannelMessagesIterable
implements SdkIterable<ListChannelMessagesResponse> {
    private final ChimeSdkMessagingClient client;
    private final ListChannelMessagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChannelMessagesIterable(ChimeSdkMessagingClient client, ListChannelMessagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChannelMessagesResponseFetcher();
    }

    public Iterator<ListChannelMessagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListChannelMessagesResponseFetcher
    implements SyncPageFetcher<ListChannelMessagesResponse> {
        private ListChannelMessagesResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelMessagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChannelMessagesResponse nextPage(ListChannelMessagesResponse previousPage) {
            if (previousPage == null) {
                return ListChannelMessagesIterable.this.client.listChannelMessages(ListChannelMessagesIterable.this.firstRequest);
            }
            return ListChannelMessagesIterable.this.client.listChannelMessages((ListChannelMessagesRequest)((Object)ListChannelMessagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

