/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmessaging.ChimeSdkMessagingClient;
import software.amazon.awssdk.services.chimesdkmessaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelFlowsRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelFlowsResponse;

public class ListChannelFlowsIterable
implements SdkIterable<ListChannelFlowsResponse> {
    private final ChimeSdkMessagingClient client;
    private final ListChannelFlowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChannelFlowsIterable(ChimeSdkMessagingClient client, ListChannelFlowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChannelFlowsResponseFetcher();
    }

    public Iterator<ListChannelFlowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListChannelFlowsResponseFetcher
    implements SyncPageFetcher<ListChannelFlowsResponse> {
        private ListChannelFlowsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChannelFlowsResponse nextPage(ListChannelFlowsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelFlowsIterable.this.client.listChannelFlows(ListChannelFlowsIterable.this.firstRequest);
            }
            return ListChannelFlowsIterable.this.client.listChannelFlows((ListChannelFlowsRequest)((Object)ListChannelFlowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

