/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMode;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelPrivacy;
import software.amazon.awssdk.services.chimesdkmessaging.model.ElasticChannelConfiguration;
import software.amazon.awssdk.services.chimesdkmessaging.model.Identity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Channel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Channel> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Channel.getter(Channel::name)).setter(Channel.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(Channel.getter(Channel::channelArn)).setter(Channel.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(Channel.getter(Channel::modeAsString)).setter(Channel.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Privacy").getter(Channel.getter(Channel::privacyAsString)).setter(Channel.setter(Builder::privacy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Privacy").build()}).build();
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metadata").getter(Channel.getter(Channel::metadata)).setter(Channel.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<Identity> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(Channel.getter(Channel::createdBy)).setter(Channel.setter(Builder::createdBy)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(Channel.getter(Channel::createdTimestamp)).setter(Channel.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_MESSAGE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastMessageTimestamp").getter(Channel.getter(Channel::lastMessageTimestamp)).setter(Channel.setter(Builder::lastMessageTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastMessageTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(Channel.getter(Channel::lastUpdatedTimestamp)).setter(Channel.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final SdkField<String> CHANNEL_FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelFlowArn").getter(Channel.getter(Channel::channelFlowArn)).setter(Channel.setter(Builder::channelFlowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelFlowArn").build()}).build();
    private static final SdkField<ElasticChannelConfiguration> ELASTIC_CHANNEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ElasticChannelConfiguration").getter(Channel.getter(Channel::elasticChannelConfiguration)).setter(Channel.setter(Builder::elasticChannelConfiguration)).constructor(ElasticChannelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticChannelConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CHANNEL_ARN_FIELD, MODE_FIELD, PRIVACY_FIELD, METADATA_FIELD, CREATED_BY_FIELD, CREATED_TIMESTAMP_FIELD, LAST_MESSAGE_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, CHANNEL_FLOW_ARN_FIELD, ELASTIC_CHANNEL_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String channelArn;
    private final String mode;
    private final String privacy;
    private final String metadata;
    private final Identity createdBy;
    private final Instant createdTimestamp;
    private final Instant lastMessageTimestamp;
    private final Instant lastUpdatedTimestamp;
    private final String channelFlowArn;
    private final ElasticChannelConfiguration elasticChannelConfiguration;

    private Channel(BuilderImpl builder) {
        this.name = builder.name;
        this.channelArn = builder.channelArn;
        this.mode = builder.mode;
        this.privacy = builder.privacy;
        this.metadata = builder.metadata;
        this.createdBy = builder.createdBy;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastMessageTimestamp = builder.lastMessageTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.channelFlowArn = builder.channelFlowArn;
        this.elasticChannelConfiguration = builder.elasticChannelConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final ChannelMode mode() {
        return ChannelMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final ChannelPrivacy privacy() {
        return ChannelPrivacy.fromValue(this.privacy);
    }

    public final String privacyAsString() {
        return this.privacy;
    }

    public final String metadata() {
        return this.metadata;
    }

    public final Identity createdBy() {
        return this.createdBy;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant lastMessageTimestamp() {
        return this.lastMessageTimestamp;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final String channelFlowArn() {
        return this.channelFlowArn;
    }

    public final ElasticChannelConfiguration elasticChannelConfiguration() {
        return this.elasticChannelConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastMessageTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelFlowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticChannelConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.privacyAsString(), other.privacyAsString()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastMessageTimestamp(), other.lastMessageTimestamp()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.channelFlowArn(), other.channelFlowArn()) && Objects.equals(this.elasticChannelConfiguration(), other.elasticChannelConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Channel").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ChannelArn", (Object)this.channelArn()).add("Mode", (Object)this.modeAsString()).add("Privacy", (Object)this.privacyAsString()).add("Metadata", (Object)(this.metadata() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedBy", (Object)this.createdBy()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastMessageTimestamp", (Object)this.lastMessageTimestamp()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("ChannelFlowArn", (Object)this.channelFlowArn()).add("ElasticChannelConfiguration", (Object)this.elasticChannelConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "Privacy": {
                return Optional.ofNullable(clazz.cast(this.privacyAsString()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "LastMessageTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastMessageTimestamp()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "ChannelFlowArn": {
                return Optional.ofNullable(clazz.cast(this.channelFlowArn()));
            }
            case "ElasticChannelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.elasticChannelConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Channel, T> g) {
        return obj -> g.apply((Channel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String channelArn;
        private String mode;
        private String privacy;
        private String metadata;
        private Identity createdBy;
        private Instant createdTimestamp;
        private Instant lastMessageTimestamp;
        private Instant lastUpdatedTimestamp;
        private String channelFlowArn;
        private ElasticChannelConfiguration elasticChannelConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Channel model) {
            this.name(model.name);
            this.channelArn(model.channelArn);
            this.mode(model.mode);
            this.privacy(model.privacy);
            this.metadata(model.metadata);
            this.createdBy(model.createdBy);
            this.createdTimestamp(model.createdTimestamp);
            this.lastMessageTimestamp(model.lastMessageTimestamp);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.channelFlowArn(model.channelFlowArn);
            this.elasticChannelConfiguration(model.elasticChannelConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ChannelMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getPrivacy() {
            return this.privacy;
        }

        public final void setPrivacy(String privacy) {
            this.privacy = privacy;
        }

        @Override
        public final Builder privacy(String privacy) {
            this.privacy = privacy;
            return this;
        }

        @Override
        public final Builder privacy(ChannelPrivacy privacy) {
            this.privacy(privacy == null ? null : privacy.toString());
            return this;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Identity.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(Identity.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(Identity createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastMessageTimestamp() {
            return this.lastMessageTimestamp;
        }

        public final void setLastMessageTimestamp(Instant lastMessageTimestamp) {
            this.lastMessageTimestamp = lastMessageTimestamp;
        }

        @Override
        public final Builder lastMessageTimestamp(Instant lastMessageTimestamp) {
            this.lastMessageTimestamp = lastMessageTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getChannelFlowArn() {
            return this.channelFlowArn;
        }

        public final void setChannelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
        }

        @Override
        public final Builder channelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
            return this;
        }

        public final ElasticChannelConfiguration.Builder getElasticChannelConfiguration() {
            return this.elasticChannelConfiguration != null ? this.elasticChannelConfiguration.toBuilder() : null;
        }

        public final void setElasticChannelConfiguration(ElasticChannelConfiguration.BuilderImpl elasticChannelConfiguration) {
            this.elasticChannelConfiguration = elasticChannelConfiguration != null ? elasticChannelConfiguration.build() : null;
        }

        @Override
        public final Builder elasticChannelConfiguration(ElasticChannelConfiguration elasticChannelConfiguration) {
            this.elasticChannelConfiguration = elasticChannelConfiguration;
            return this;
        }

        public Channel build() {
            return new Channel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Channel> {
        public Builder name(String var1);

        public Builder channelArn(String var1);

        public Builder mode(String var1);

        public Builder mode(ChannelMode var1);

        public Builder privacy(String var1);

        public Builder privacy(ChannelPrivacy var1);

        public Builder metadata(String var1);

        public Builder createdBy(Identity var1);

        default public Builder createdBy(Consumer<Identity.Builder> createdBy) {
            return this.createdBy((Identity)((Identity.Builder)Identity.builder().applyMutation(createdBy)).build());
        }

        public Builder createdTimestamp(Instant var1);

        public Builder lastMessageTimestamp(Instant var1);

        public Builder lastUpdatedTimestamp(Instant var1);

        public Builder channelFlowArn(String var1);

        public Builder elasticChannelConfiguration(ElasticChannelConfiguration var1);

        default public Builder elasticChannelConfiguration(Consumer<ElasticChannelConfiguration.Builder> elasticChannelConfiguration) {
            return this.elasticChannelConfiguration((ElasticChannelConfiguration)((ElasticChannelConfiguration.Builder)ElasticChannelConfiguration.builder().applyMutation(elasticChannelConfiguration)).build());
        }
    }
}

