/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.chimesdkmessaging.model.MessageAttributeMapCopier;
import software.amazon.awssdk.services.chimesdkmessaging.model.MessageAttributeValue;
import software.amazon.awssdk.services.chimesdkmessaging.model.PushNotificationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelMessageCallback
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelMessageCallback> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(ChannelMessageCallback.getter(ChannelMessageCallback::messageId)).setter(ChannelMessageCallback.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(ChannelMessageCallback.getter(ChannelMessageCallback::content)).setter(ChannelMessageCallback.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metadata").getter(ChannelMessageCallback.getter(ChannelMessageCallback::metadata)).setter(ChannelMessageCallback.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<PushNotificationConfiguration> PUSH_NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PushNotification").getter(ChannelMessageCallback.getter(ChannelMessageCallback::pushNotification)).setter(ChannelMessageCallback.setter(Builder::pushNotification)).constructor(PushNotificationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PushNotification").build()}).build();
    private static final SdkField<Map<String, MessageAttributeValue>> MESSAGE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MessageAttributes").getter(ChannelMessageCallback.getter(ChannelMessageCallback::messageAttributes)).setter(ChannelMessageCallback.setter(Builder::messageAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, CONTENT_FIELD, METADATA_FIELD, PUSH_NOTIFICATION_FIELD, MESSAGE_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String messageId;
    private final String content;
    private final String metadata;
    private final PushNotificationConfiguration pushNotification;
    private final Map<String, MessageAttributeValue> messageAttributes;

    private ChannelMessageCallback(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.content = builder.content;
        this.metadata = builder.metadata;
        this.pushNotification = builder.pushNotification;
        this.messageAttributes = builder.messageAttributes;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final String content() {
        return this.content;
    }

    public final String metadata() {
        return this.metadata;
    }

    public final PushNotificationConfiguration pushNotification() {
        return this.pushNotification;
    }

    public final boolean hasMessageAttributes() {
        return this.messageAttributes != null && !(this.messageAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, MessageAttributeValue> messageAttributes() {
        return this.messageAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.pushNotification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageAttributes() ? this.messageAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelMessageCallback)) {
            return false;
        }
        ChannelMessageCallback other = (ChannelMessageCallback)obj;
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.pushNotification(), other.pushNotification()) && this.hasMessageAttributes() == other.hasMessageAttributes() && Objects.equals(this.messageAttributes(), other.messageAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelMessageCallback").add("MessageId", (Object)this.messageId()).add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).add("Metadata", (Object)(this.metadata() == null ? null : "*** Sensitive Data Redacted ***")).add("PushNotification", (Object)this.pushNotification()).add("MessageAttributes", (Object)(this.messageAttributes() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "PushNotification": {
                return Optional.ofNullable(clazz.cast(this.pushNotification()));
            }
            case "MessageAttributes": {
                return Optional.ofNullable(clazz.cast(this.messageAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelMessageCallback, T> g) {
        return obj -> g.apply((ChannelMessageCallback)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageId;
        private String content;
        private String metadata;
        private PushNotificationConfiguration pushNotification;
        private Map<String, MessageAttributeValue> messageAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelMessageCallback model) {
            this.messageId(model.messageId);
            this.content(model.content);
            this.metadata(model.metadata);
            this.pushNotification(model.pushNotification);
            this.messageAttributes(model.messageAttributes);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final PushNotificationConfiguration.Builder getPushNotification() {
            return this.pushNotification != null ? this.pushNotification.toBuilder() : null;
        }

        public final void setPushNotification(PushNotificationConfiguration.BuilderImpl pushNotification) {
            this.pushNotification = pushNotification != null ? pushNotification.build() : null;
        }

        @Override
        public final Builder pushNotification(PushNotificationConfiguration pushNotification) {
            this.pushNotification = pushNotification;
            return this;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            Map<String, MessageAttributeValue.Builder> result = MessageAttributeMapCopier.copyToBuilder(this.messageAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public ChannelMessageCallback build() {
            return new ChannelMessageCallback(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelMessageCallback> {
        public Builder messageId(String var1);

        public Builder content(String var1);

        public Builder metadata(String var1);

        public Builder pushNotification(PushNotificationConfiguration var1);

        default public Builder pushNotification(Consumer<PushNotificationConfiguration.Builder> pushNotification) {
            return this.pushNotification((PushNotificationConfiguration)((PushNotificationConfiguration.Builder)PushNotificationConfiguration.builder().applyMutation(pushNotification)).build());
        }

        public Builder messageAttributes(Map<String, MessageAttributeValue> var1);
    }
}

