/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttendeeCapabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttendeeCapabilities> {
    private static final SdkField<String> AUDIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Audio").getter(AttendeeCapabilities.getter(AttendeeCapabilities::audioAsString)).setter(AttendeeCapabilities.setter(Builder::audio)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audio").build()}).build();
    private static final SdkField<String> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Video").getter(AttendeeCapabilities.getter(AttendeeCapabilities::videoAsString)).setter(AttendeeCapabilities.setter(Builder::video)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(AttendeeCapabilities.getter(AttendeeCapabilities::contentAsString)).setter(AttendeeCapabilities.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_FIELD, VIDEO_FIELD, CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttendeeCapabilities.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String audio;
    private final String video;
    private final String content;

    private AttendeeCapabilities(BuilderImpl builder) {
        this.audio = builder.audio;
        this.video = builder.video;
        this.content = builder.content;
    }

    public final MediaCapabilities audio() {
        return MediaCapabilities.fromValue(this.audio);
    }

    public final String audioAsString() {
        return this.audio;
    }

    public final MediaCapabilities video() {
        return MediaCapabilities.fromValue(this.video);
    }

    public final String videoAsString() {
        return this.video;
    }

    public final MediaCapabilities content() {
        return MediaCapabilities.fromValue(this.content);
    }

    public final String contentAsString() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttendeeCapabilities)) {
            return false;
        }
        AttendeeCapabilities other = (AttendeeCapabilities)obj;
        return Objects.equals(this.audioAsString(), other.audioAsString()) && Objects.equals(this.videoAsString(), other.videoAsString()) && Objects.equals(this.contentAsString(), other.contentAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AttendeeCapabilities").add("Audio", (Object)this.audioAsString()).add("Video", (Object)this.videoAsString()).add("Content", (Object)this.contentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Audio": {
                return Optional.ofNullable(clazz.cast(this.audioAsString()));
            }
            case "Video": {
                return Optional.ofNullable(clazz.cast(this.videoAsString()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.contentAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Audio", AUDIO_FIELD);
        map.put("Video", VIDEO_FIELD);
        map.put("Content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttendeeCapabilities, T> g) {
        return obj -> g.apply((AttendeeCapabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audio;
        private String video;
        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(AttendeeCapabilities model) {
            this.audio(model.audio);
            this.video(model.video);
            this.content(model.content);
        }

        public final String getAudio() {
            return this.audio;
        }

        public final void setAudio(String audio) {
            this.audio = audio;
        }

        @Override
        public final Builder audio(String audio) {
            this.audio = audio;
            return this;
        }

        @Override
        public final Builder audio(MediaCapabilities audio) {
            this.audio(audio == null ? null : audio.toString());
            return this;
        }

        public final String getVideo() {
            return this.video;
        }

        public final void setVideo(String video) {
            this.video = video;
        }

        @Override
        public final Builder video(String video) {
            this.video = video;
            return this;
        }

        @Override
        public final Builder video(MediaCapabilities video) {
            this.video(video == null ? null : video.toString());
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        @Override
        public final Builder content(MediaCapabilities content) {
            this.content(content == null ? null : content.toString());
            return this;
        }

        public AttendeeCapabilities build() {
            return new AttendeeCapabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttendeeCapabilities> {
        public Builder audio(String var1);

        public Builder audio(MediaCapabilities var1);

        public Builder video(String var1);

        public Builder video(MediaCapabilities var1);

        public Builder content(String var1);

        public Builder content(MediaCapabilities var1);
    }
}

