/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmeetings.ChimeSdkMeetingsAsyncClient;
import software.amazon.awssdk.services.chimesdkmeetings.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkmeetings.model.ListAttendeesRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.ListAttendeesResponse;

public class ListAttendeesPublisher
implements SdkPublisher<ListAttendeesResponse> {
    private final ChimeSdkMeetingsAsyncClient client;
    private final ListAttendeesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttendeesPublisher(ChimeSdkMeetingsAsyncClient client, ListAttendeesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttendeesPublisher(ChimeSdkMeetingsAsyncClient client, ListAttendeesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttendeesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttendeesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAttendeesResponseFetcher
    implements AsyncPageFetcher<ListAttendeesResponse> {
        private ListAttendeesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttendeesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAttendeesResponse> nextPage(ListAttendeesResponse previousPage) {
            if (previousPage == null) {
                return ListAttendeesPublisher.this.client.listAttendees(ListAttendeesPublisher.this.firstRequest);
            }
            return ListAttendeesPublisher.this.client.listAttendees((ListAttendeesRequest)((Object)ListAttendeesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

