/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeCapabilities;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Attendee
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Attendee> {
    private static final SdkField<String> EXTERNAL_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalUserId").getter(Attendee.getter(Attendee::externalUserId)).setter(Attendee.setter(Builder::externalUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalUserId").build()}).build();
    private static final SdkField<String> ATTENDEE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttendeeId").getter(Attendee.getter(Attendee::attendeeId)).setter(Attendee.setter(Builder::attendeeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttendeeId").build()}).build();
    private static final SdkField<String> JOIN_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JoinToken").getter(Attendee.getter(Attendee::joinToken)).setter(Attendee.setter(Builder::joinToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinToken").build()}).build();
    private static final SdkField<AttendeeCapabilities> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Capabilities").getter(Attendee.getter(Attendee::capabilities)).setter(Attendee.setter(Builder::capabilities)).constructor(AttendeeCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_USER_ID_FIELD, ATTENDEE_ID_FIELD, JOIN_TOKEN_FIELD, CAPABILITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ExternalUserId", EXTERNAL_USER_ID_FIELD);
            this.put("AttendeeId", ATTENDEE_ID_FIELD);
            this.put("JoinToken", JOIN_TOKEN_FIELD);
            this.put("Capabilities", CAPABILITIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String externalUserId;
    private final String attendeeId;
    private final String joinToken;
    private final AttendeeCapabilities capabilities;

    private Attendee(BuilderImpl builder) {
        this.externalUserId = builder.externalUserId;
        this.attendeeId = builder.attendeeId;
        this.joinToken = builder.joinToken;
        this.capabilities = builder.capabilities;
    }

    public final String externalUserId() {
        return this.externalUserId;
    }

    public final String attendeeId() {
        return this.attendeeId;
    }

    public final String joinToken() {
        return this.joinToken;
    }

    public final AttendeeCapabilities capabilities() {
        return this.capabilities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.externalUserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attendeeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.joinToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilities());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attendee)) {
            return false;
        }
        Attendee other = (Attendee)obj;
        return Objects.equals(this.externalUserId(), other.externalUserId()) && Objects.equals(this.attendeeId(), other.attendeeId()) && Objects.equals(this.joinToken(), other.joinToken()) && Objects.equals(this.capabilities(), other.capabilities());
    }

    public final String toString() {
        return ToString.builder((String)"Attendee").add("ExternalUserId", (Object)(this.externalUserId() == null ? null : "*** Sensitive Data Redacted ***")).add("AttendeeId", (Object)this.attendeeId()).add("JoinToken", (Object)(this.joinToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Capabilities", (Object)this.capabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExternalUserId": {
                return Optional.ofNullable(clazz.cast(this.externalUserId()));
            }
            case "AttendeeId": {
                return Optional.ofNullable(clazz.cast(this.attendeeId()));
            }
            case "JoinToken": {
                return Optional.ofNullable(clazz.cast(this.joinToken()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Attendee, T> g) {
        return obj -> g.apply((Attendee)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String externalUserId;
        private String attendeeId;
        private String joinToken;
        private AttendeeCapabilities capabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(Attendee model) {
            this.externalUserId(model.externalUserId);
            this.attendeeId(model.attendeeId);
            this.joinToken(model.joinToken);
            this.capabilities(model.capabilities);
        }

        public final String getExternalUserId() {
            return this.externalUserId;
        }

        public final void setExternalUserId(String externalUserId) {
            this.externalUserId = externalUserId;
        }

        @Override
        public final Builder externalUserId(String externalUserId) {
            this.externalUserId = externalUserId;
            return this;
        }

        public final String getAttendeeId() {
            return this.attendeeId;
        }

        public final void setAttendeeId(String attendeeId) {
            this.attendeeId = attendeeId;
        }

        @Override
        public final Builder attendeeId(String attendeeId) {
            this.attendeeId = attendeeId;
            return this;
        }

        public final String getJoinToken() {
            return this.joinToken;
        }

        public final void setJoinToken(String joinToken) {
            this.joinToken = joinToken;
        }

        @Override
        public final Builder joinToken(String joinToken) {
            this.joinToken = joinToken;
            return this;
        }

        public final AttendeeCapabilities.Builder getCapabilities() {
            return this.capabilities != null ? this.capabilities.toBuilder() : null;
        }

        public final void setCapabilities(AttendeeCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(AttendeeCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Attendee build() {
            return new Attendee(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Attendee> {
        public Builder externalUserId(String var1);

        public Builder attendeeId(String var1);

        public Builder joinToken(String var1);

        public Builder capabilities(AttendeeCapabilities var1);

        default public Builder capabilities(Consumer<AttendeeCapabilities.Builder> capabilities) {
            return this.capabilities((AttendeeCapabilities)((AttendeeCapabilities.Builder)AttendeeCapabilities.builder().applyMutation(capabilities)).build());
        }
    }
}

