/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TranscribeRegion {
    US_EAST_2("us-east-2"),
    US_EAST_1("us-east-1"),
    US_WEST_2("us-west-2"),
    AP_NORTHEAST_2("ap-northeast-2"),
    AP_SOUTHEAST_2("ap-southeast-2"),
    AP_NORTHEAST_1("ap-northeast-1"),
    CA_CENTRAL_1("ca-central-1"),
    EU_CENTRAL_1("eu-central-1"),
    EU_WEST_1("eu-west-1"),
    EU_WEST_2("eu-west-2"),
    SA_EAST_1("sa-east-1"),
    AUTO("auto"),
    US_GOV_WEST_1("us-gov-west-1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TranscribeRegion> VALUE_MAP;
    private final String value;

    private TranscribeRegion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TranscribeRegion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TranscribeRegion> knownValues() {
        EnumSet<TranscribeRegion> knownValues = EnumSet.allOf(TranscribeRegion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TranscribeRegion.class, TranscribeRegion::toString);
    }
}

