/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.chimesdkmeetings.ChimeSdkMeetingsClient;
import software.amazon.awssdk.services.chimesdkmeetings.ChimeSdkMeetingsServiceClientConfiguration;
import software.amazon.awssdk.services.chimesdkmeetings.internal.ChimeSdkMeetingsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.chimesdkmeetings.model.BadRequestException;
import software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.BatchUpdateAttendeeCapabilitiesExceptResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.ChimeSdkMeetingsException;
import software.amazon.awssdk.services.chimesdkmeetings.model.ConflictException;
import software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.DeleteAttendeeRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.DeleteAttendeeResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.DeleteMeetingRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.DeleteMeetingResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.ForbiddenException;
import software.amazon.awssdk.services.chimesdkmeetings.model.GetAttendeeRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.GetAttendeeResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.GetMeetingRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.GetMeetingResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.LimitExceededException;
import software.amazon.awssdk.services.chimesdkmeetings.model.ListAttendeesRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.ListAttendeesResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.NotFoundException;
import software.amazon.awssdk.services.chimesdkmeetings.model.ResourceNotFoundException;
import software.amazon.awssdk.services.chimesdkmeetings.model.ServiceFailureException;
import software.amazon.awssdk.services.chimesdkmeetings.model.ServiceUnavailableException;
import software.amazon.awssdk.services.chimesdkmeetings.model.StartMeetingTranscriptionRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.StartMeetingTranscriptionResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.StopMeetingTranscriptionRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.StopMeetingTranscriptionResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.TagResourceRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.TagResourceResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.ThrottlingException;
import software.amazon.awssdk.services.chimesdkmeetings.model.TooManyTagsException;
import software.amazon.awssdk.services.chimesdkmeetings.model.UnauthorizedException;
import software.amazon.awssdk.services.chimesdkmeetings.model.UnprocessableEntityException;
import software.amazon.awssdk.services.chimesdkmeetings.model.UntagResourceRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.UntagResourceResponse;
import software.amazon.awssdk.services.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.UpdateAttendeeCapabilitiesResponse;
import software.amazon.awssdk.services.chimesdkmeetings.transform.BatchCreateAttendeeRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.BatchUpdateAttendeeCapabilitiesExceptRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.CreateAttendeeRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.CreateMeetingRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.CreateMeetingWithAttendeesRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.DeleteAttendeeRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.DeleteMeetingRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.GetAttendeeRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.GetMeetingRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.ListAttendeesRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.StartMeetingTranscriptionRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.StopMeetingTranscriptionRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmeetings.transform.UpdateAttendeeCapabilitiesRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultChimeSdkMeetingsClient
implements ChimeSdkMeetingsClient {
    private static final Logger log = Logger.loggerFor(DefaultChimeSdkMeetingsClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultChimeSdkMeetingsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchCreateAttendeeResponse batchCreateAttendee(BatchCreateAttendeeRequest batchCreateAttendeeRequest) throws BadRequestException, ForbiddenException, NotFoundException, UnauthorizedException, UnprocessableEntityException, LimitExceededException, ServiceUnavailableException, ServiceFailureException, ThrottlingException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchCreateAttendeeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchCreateAttendeeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, batchCreateAttendeeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchCreateAttendee");
            BatchCreateAttendeeResponse batchCreateAttendeeResponse = (BatchCreateAttendeeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchCreateAttendee").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchCreateAttendeeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchCreateAttendeeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchCreateAttendeeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$batchCreateAttendee$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchUpdateAttendeeCapabilitiesExceptResponse batchUpdateAttendeeCapabilitiesExcept(BatchUpdateAttendeeCapabilitiesExceptRequest batchUpdateAttendeeCapabilitiesExceptRequest) throws BadRequestException, ConflictException, UnauthorizedException, NotFoundException, ForbiddenException, ServiceUnavailableException, ServiceFailureException, ThrottlingException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpdateAttendeeCapabilitiesExceptResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchUpdateAttendeeCapabilitiesExceptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, batchUpdateAttendeeCapabilitiesExceptRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUpdateAttendeeCapabilitiesExcept");
            BatchUpdateAttendeeCapabilitiesExceptResponse batchUpdateAttendeeCapabilitiesExceptResponse = (BatchUpdateAttendeeCapabilitiesExceptResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpdateAttendeeCapabilitiesExcept").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchUpdateAttendeeCapabilitiesExceptRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchUpdateAttendeeCapabilitiesExceptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchUpdateAttendeeCapabilitiesExceptResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$batchUpdateAttendeeCapabilitiesExcept$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAttendeeResponse createAttendee(CreateAttendeeRequest createAttendeeRequest) throws BadRequestException, ForbiddenException, NotFoundException, UnauthorizedException, UnprocessableEntityException, LimitExceededException, ServiceUnavailableException, ServiceFailureException, ThrottlingException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAttendeeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAttendeeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, createAttendeeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAttendee");
            CreateAttendeeResponse createAttendeeResponse = (CreateAttendeeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAttendee").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAttendeeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAttendeeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAttendeeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$createAttendee$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMeetingResponse createMeeting(CreateMeetingRequest createMeetingRequest) throws BadRequestException, ConflictException, ForbiddenException, UnauthorizedException, ThrottlingException, ServiceFailureException, ServiceUnavailableException, LimitExceededException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMeetingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMeetingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, createMeetingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMeeting");
            CreateMeetingResponse createMeetingResponse = (CreateMeetingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMeeting").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createMeetingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMeetingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMeetingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$createMeeting$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMeetingWithAttendeesResponse createMeetingWithAttendees(CreateMeetingWithAttendeesRequest createMeetingWithAttendeesRequest) throws BadRequestException, ConflictException, ForbiddenException, UnauthorizedException, ThrottlingException, ServiceFailureException, ServiceUnavailableException, LimitExceededException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMeetingWithAttendeesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMeetingWithAttendeesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, createMeetingWithAttendeesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMeetingWithAttendees");
            CreateMeetingWithAttendeesResponse createMeetingWithAttendeesResponse = (CreateMeetingWithAttendeesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMeetingWithAttendees").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createMeetingWithAttendeesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMeetingWithAttendeesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMeetingWithAttendeesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$createMeetingWithAttendees$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAttendeeResponse deleteAttendee(DeleteAttendeeRequest deleteAttendeeRequest) throws BadRequestException, ForbiddenException, NotFoundException, UnauthorizedException, ServiceUnavailableException, ServiceFailureException, ThrottlingException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAttendeeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAttendeeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, deleteAttendeeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAttendee");
            DeleteAttendeeResponse deleteAttendeeResponse = (DeleteAttendeeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAttendee").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAttendeeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAttendeeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAttendeeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$deleteAttendee$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMeetingResponse deleteMeeting(DeleteMeetingRequest deleteMeetingRequest) throws BadRequestException, ForbiddenException, UnauthorizedException, NotFoundException, ServiceUnavailableException, ServiceFailureException, ThrottlingException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMeetingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMeetingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, deleteMeetingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMeeting");
            DeleteMeetingResponse deleteMeetingResponse = (DeleteMeetingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMeeting").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteMeetingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMeetingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMeetingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$deleteMeeting$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAttendeeResponse getAttendee(GetAttendeeRequest getAttendeeRequest) throws BadRequestException, ForbiddenException, NotFoundException, UnauthorizedException, ServiceUnavailableException, ServiceFailureException, ThrottlingException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAttendeeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAttendeeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, getAttendeeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAttendee");
            GetAttendeeResponse getAttendeeResponse = (GetAttendeeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAttendee").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAttendeeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAttendeeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAttendeeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$getAttendee$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMeetingResponse getMeeting(GetMeetingRequest getMeetingRequest) throws NotFoundException, BadRequestException, ForbiddenException, UnauthorizedException, ServiceUnavailableException, ServiceFailureException, ThrottlingException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMeetingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMeetingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, getMeetingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMeeting");
            GetMeetingResponse getMeetingResponse = (GetMeetingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMeeting").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMeetingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMeetingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMeetingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$getMeeting$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAttendeesResponse listAttendees(ListAttendeesRequest listAttendeesRequest) throws BadRequestException, ForbiddenException, NotFoundException, UnauthorizedException, ServiceUnavailableException, ServiceFailureException, ThrottlingException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAttendeesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAttendeesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, listAttendeesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAttendees");
            ListAttendeesResponse listAttendeesResponse = (ListAttendeesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAttendees").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAttendeesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAttendeesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAttendeesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$listAttendees$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, ForbiddenException, UnauthorizedException, LimitExceededException, ServiceUnavailableException, ServiceFailureException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$listTagsForResource$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartMeetingTranscriptionResponse startMeetingTranscription(StartMeetingTranscriptionRequest startMeetingTranscriptionRequest) throws NotFoundException, ForbiddenException, BadRequestException, UnauthorizedException, LimitExceededException, UnprocessableEntityException, ThrottlingException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMeetingTranscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startMeetingTranscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, startMeetingTranscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMeetingTranscription");
            StartMeetingTranscriptionResponse startMeetingTranscriptionResponse = (StartMeetingTranscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMeetingTranscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startMeetingTranscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartMeetingTranscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startMeetingTranscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$startMeetingTranscription$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopMeetingTranscriptionResponse stopMeetingTranscription(StopMeetingTranscriptionRequest stopMeetingTranscriptionRequest) throws ForbiddenException, NotFoundException, BadRequestException, UnauthorizedException, UnprocessableEntityException, ThrottlingException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopMeetingTranscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopMeetingTranscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, stopMeetingTranscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopMeetingTranscription");
            StopMeetingTranscriptionResponse stopMeetingTranscriptionResponse = (StopMeetingTranscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopMeetingTranscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopMeetingTranscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopMeetingTranscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopMeetingTranscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$stopMeetingTranscription$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, ForbiddenException, UnauthorizedException, LimitExceededException, ServiceUnavailableException, ServiceFailureException, ThrottlingException, ResourceNotFoundException, TooManyTagsException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$tagResource$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, ForbiddenException, UnauthorizedException, LimitExceededException, ServiceUnavailableException, ServiceFailureException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$untagResource$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAttendeeCapabilitiesResponse updateAttendeeCapabilities(UpdateAttendeeCapabilitiesRequest updateAttendeeCapabilitiesRequest) throws BadRequestException, ConflictException, UnauthorizedException, NotFoundException, ForbiddenException, ServiceUnavailableException, ServiceFailureException, ThrottlingException, AwsServiceException, SdkClientException, ChimeSdkMeetingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAttendeeCapabilitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAttendeeCapabilitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkMeetingsClient.resolveMetricPublishers(clientConfiguration, updateAttendeeCapabilitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Meetings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAttendeeCapabilities");
            UpdateAttendeeCapabilitiesResponse updateAttendeeCapabilitiesResponse = (UpdateAttendeeCapabilitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAttendeeCapabilities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAttendeeCapabilitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAttendeeCapabilitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAttendeeCapabilitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkMeetingsClient.lambda$updateAttendeeCapabilities$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "chime";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ChimeSdkMeetingsServiceClientConfigurationBuilder serviceConfigBuilder = new ChimeSdkMeetingsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ChimeSdkMeetingsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").exceptionBuilderSupplier(UnprocessableEntityException::builder).httpStatusCode(Integer.valueOf(422)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedException").exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ForbiddenException").exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceFailureException").exceptionBuilderSupplier(ServiceFailureException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final ChimeSdkMeetingsServiceClientConfiguration serviceClientConfiguration() {
        return new ChimeSdkMeetingsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateAttendeeCapabilities$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopMeetingTranscription$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startMeetingTranscription$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAttendees$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMeeting$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAttendee$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMeeting$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAttendee$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMeetingWithAttendees$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMeeting$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAttendee$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUpdateAttendeeCapabilitiesExcept$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchCreateAttendee$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

