/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A meeting created using the Amazon Chime SDK.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Meeting implements SdkPojo, Serializable, ToCopyableBuilder<Meeting.Builder, Meeting> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeetingId").getter(getter(Meeting::meetingId)).setter(setter(Builder::meetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingId").build()).build();

    private static final SdkField<String> MEETING_HOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeetingHostId").getter(getter(Meeting::meetingHostId)).setter(setter(Builder::meetingHostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingHostId").build()).build();

    private static final SdkField<String> EXTERNAL_MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalMeetingId").getter(getter(Meeting::externalMeetingId))
            .setter(setter(Builder::externalMeetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalMeetingId").build()).build();

    private static final SdkField<String> MEDIA_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaRegion").getter(getter(Meeting::mediaRegion)).setter(setter(Builder::mediaRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaRegion").build()).build();

    private static final SdkField<MediaPlacement> MEDIA_PLACEMENT_FIELD = SdkField
            .<MediaPlacement> builder(MarshallingType.SDK_POJO).memberName("MediaPlacement")
            .getter(getter(Meeting::mediaPlacement)).setter(setter(Builder::mediaPlacement)).constructor(MediaPlacement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPlacement").build()).build();

    private static final SdkField<MeetingFeaturesConfiguration> MEETING_FEATURES_FIELD = SdkField
            .<MeetingFeaturesConfiguration> builder(MarshallingType.SDK_POJO).memberName("MeetingFeatures")
            .getter(getter(Meeting::meetingFeatures)).setter(setter(Builder::meetingFeatures))
            .constructor(MeetingFeaturesConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingFeatures").build()).build();

    private static final SdkField<String> PRIMARY_MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryMeetingId").getter(getter(Meeting::primaryMeetingId)).setter(setter(Builder::primaryMeetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryMeetingId").build()).build();

    private static final SdkField<List<String>> TENANT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TenantIds")
            .getter(getter(Meeting::tenantIds))
            .setter(setter(Builder::tenantIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MEETING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeetingArn").getter(getter(Meeting::meetingArn)).setter(setter(Builder::meetingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD,
            MEETING_HOST_ID_FIELD, EXTERNAL_MEETING_ID_FIELD, MEDIA_REGION_FIELD, MEDIA_PLACEMENT_FIELD, MEETING_FEATURES_FIELD,
            PRIMARY_MEETING_ID_FIELD, TENANT_IDS_FIELD, MEETING_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String meetingId;

    private final String meetingHostId;

    private final String externalMeetingId;

    private final String mediaRegion;

    private final MediaPlacement mediaPlacement;

    private final MeetingFeaturesConfiguration meetingFeatures;

    private final String primaryMeetingId;

    private final List<String> tenantIds;

    private final String meetingArn;

    private Meeting(BuilderImpl builder) {
        this.meetingId = builder.meetingId;
        this.meetingHostId = builder.meetingHostId;
        this.externalMeetingId = builder.externalMeetingId;
        this.mediaRegion = builder.mediaRegion;
        this.mediaPlacement = builder.mediaPlacement;
        this.meetingFeatures = builder.meetingFeatures;
        this.primaryMeetingId = builder.primaryMeetingId;
        this.tenantIds = builder.tenantIds;
        this.meetingArn = builder.meetingArn;
    }

    /**
     * <p>
     * The Amazon Chime SDK meeting ID.
     * </p>
     * 
     * @return The Amazon Chime SDK meeting ID.
     */
    public final String meetingId() {
        return meetingId;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String meetingHostId() {
        return meetingHostId;
    }

    /**
     * <p>
     * The external meeting ID.
     * </p>
     * <p>
     * Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
     * </p>
     * <p>
     * Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this prefix. Case
     * insensitive.
     * </p>
     * 
     * @return The external meeting ID.</p>
     *         <p>
     *         Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
     *         </p>
     *         <p>
     *         Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this prefix.
     *         Case insensitive.
     */
    public final String externalMeetingId() {
        return externalMeetingId;
    }

    /**
     * <p>
     * The Region in which you create the meeting. Available values: <code>af-south-1</code>,
     * <code>ap-northeast-1</code>, <code>ap-northeast-2</code>, <code>ap-south-1</code>, <code>ap-southeast-1</code>,
     * <code>ap-southeast-2</code>, <code>ca-central-1</code>, <code>eu-central-1</code>, <code>eu-north-1</code>,
     * <code>eu-south-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>,
     * <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>, <code>us-west-1</code>,
     * <code>us-west-2</code>.
     * </p>
     * <p>
     * Available values in AWS GovCloud (US) Regions: <code>us-gov-east-1</code>, <code>us-gov-west-1</code>.
     * </p>
     * 
     * @return The Region in which you create the meeting. Available values: <code>af-south-1</code>,
     *         <code>ap-northeast-1</code>, <code>ap-northeast-2</code>, <code>ap-south-1</code>,
     *         <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
     *         <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>,
     *         <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>,
     *         <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>.</p>
     *         <p>
     *         Available values in AWS GovCloud (US) Regions: <code>us-gov-east-1</code>, <code>us-gov-west-1</code>.
     */
    public final String mediaRegion() {
        return mediaRegion;
    }

    /**
     * <p>
     * The media placement for the meeting.
     * </p>
     * 
     * @return The media placement for the meeting.
     */
    public final MediaPlacement mediaPlacement() {
        return mediaPlacement;
    }

    /**
     * <p>
     * The features available to a meeting, such as echo reduction.
     * </p>
     * 
     * @return The features available to a meeting, such as echo reduction.
     */
    public final MeetingFeaturesConfiguration meetingFeatures() {
        return meetingFeatures;
    }

    /**
     * <p>
     * When specified, replicates the media from the primary meeting to this meeting.
     * </p>
     * 
     * @return When specified, replicates the media from the primary meeting to this meeting.
     */
    public final String primaryMeetingId() {
        return primaryMeetingId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TenantIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTenantIds() {
        return tenantIds != null && !(tenantIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of strings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTenantIds} method.
     * </p>
     * 
     * @return Array of strings.
     */
    public final List<String> tenantIds() {
        return tenantIds;
    }

    /**
     * <p>
     * The ARN of the meeting.
     * </p>
     * 
     * @return The ARN of the meeting.
     */
    public final String meetingArn() {
        return meetingArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(meetingHostId());
        hashCode = 31 * hashCode + Objects.hashCode(externalMeetingId());
        hashCode = 31 * hashCode + Objects.hashCode(mediaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(mediaPlacement());
        hashCode = 31 * hashCode + Objects.hashCode(meetingFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(primaryMeetingId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTenantIds() ? tenantIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(meetingArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Meeting)) {
            return false;
        }
        Meeting other = (Meeting) obj;
        return Objects.equals(meetingId(), other.meetingId()) && Objects.equals(meetingHostId(), other.meetingHostId())
                && Objects.equals(externalMeetingId(), other.externalMeetingId())
                && Objects.equals(mediaRegion(), other.mediaRegion()) && Objects.equals(mediaPlacement(), other.mediaPlacement())
                && Objects.equals(meetingFeatures(), other.meetingFeatures())
                && Objects.equals(primaryMeetingId(), other.primaryMeetingId()) && hasTenantIds() == other.hasTenantIds()
                && Objects.equals(tenantIds(), other.tenantIds()) && Objects.equals(meetingArn(), other.meetingArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Meeting").add("MeetingId", meetingId())
                .add("MeetingHostId", meetingHostId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExternalMeetingId", externalMeetingId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MediaRegion", mediaRegion()).add("MediaPlacement", mediaPlacement())
                .add("MeetingFeatures", meetingFeatures()).add("PrimaryMeetingId", primaryMeetingId())
                .add("TenantIds", hasTenantIds() ? tenantIds() : null).add("MeetingArn", meetingArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeetingId":
            return Optional.ofNullable(clazz.cast(meetingId()));
        case "MeetingHostId":
            return Optional.ofNullable(clazz.cast(meetingHostId()));
        case "ExternalMeetingId":
            return Optional.ofNullable(clazz.cast(externalMeetingId()));
        case "MediaRegion":
            return Optional.ofNullable(clazz.cast(mediaRegion()));
        case "MediaPlacement":
            return Optional.ofNullable(clazz.cast(mediaPlacement()));
        case "MeetingFeatures":
            return Optional.ofNullable(clazz.cast(meetingFeatures()));
        case "PrimaryMeetingId":
            return Optional.ofNullable(clazz.cast(primaryMeetingId()));
        case "TenantIds":
            return Optional.ofNullable(clazz.cast(tenantIds()));
        case "MeetingArn":
            return Optional.ofNullable(clazz.cast(meetingArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Meeting, T> g) {
        return obj -> g.apply((Meeting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Meeting> {
        /**
         * <p>
         * The Amazon Chime SDK meeting ID.
         * </p>
         * 
         * @param meetingId
         *        The Amazon Chime SDK meeting ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingId(String meetingId);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param meetingHostId
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingHostId(String meetingHostId);

        /**
         * <p>
         * The external meeting ID.
         * </p>
         * <p>
         * Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
         * </p>
         * <p>
         * Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this prefix.
         * Case insensitive.
         * </p>
         * 
         * @param externalMeetingId
         *        The external meeting ID.</p>
         *        <p>
         *        Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
         *        </p>
         *        <p>
         *        Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this
         *        prefix. Case insensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalMeetingId(String externalMeetingId);

        /**
         * <p>
         * The Region in which you create the meeting. Available values: <code>af-south-1</code>,
         * <code>ap-northeast-1</code>, <code>ap-northeast-2</code>, <code>ap-south-1</code>,
         * <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
         * <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>,
         * <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>,
         * <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>.
         * </p>
         * <p>
         * Available values in AWS GovCloud (US) Regions: <code>us-gov-east-1</code>, <code>us-gov-west-1</code>.
         * </p>
         * 
         * @param mediaRegion
         *        The Region in which you create the meeting. Available values: <code>af-south-1</code>,
         *        <code>ap-northeast-1</code>, <code>ap-northeast-2</code>, <code>ap-south-1</code>,
         *        <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
         *        <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>,
         *        <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>,
         *        <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>.</p>
         *        <p>
         *        Available values in AWS GovCloud (US) Regions: <code>us-gov-east-1</code>, <code>us-gov-west-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaRegion(String mediaRegion);

        /**
         * <p>
         * The media placement for the meeting.
         * </p>
         * 
         * @param mediaPlacement
         *        The media placement for the meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPlacement(MediaPlacement mediaPlacement);

        /**
         * <p>
         * The media placement for the meeting.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaPlacement.Builder} avoiding the need
         * to create one manually via {@link MediaPlacement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaPlacement.Builder#build()} is called immediately and its
         * result is passed to {@link #mediaPlacement(MediaPlacement)}.
         * 
         * @param mediaPlacement
         *        a consumer that will call methods on {@link MediaPlacement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaPlacement(MediaPlacement)
         */
        default Builder mediaPlacement(Consumer<MediaPlacement.Builder> mediaPlacement) {
            return mediaPlacement(MediaPlacement.builder().applyMutation(mediaPlacement).build());
        }

        /**
         * <p>
         * The features available to a meeting, such as echo reduction.
         * </p>
         * 
         * @param meetingFeatures
         *        The features available to a meeting, such as echo reduction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingFeatures(MeetingFeaturesConfiguration meetingFeatures);

        /**
         * <p>
         * The features available to a meeting, such as echo reduction.
         * </p>
         * This is a convenience method that creates an instance of the {@link MeetingFeaturesConfiguration.Builder}
         * avoiding the need to create one manually via {@link MeetingFeaturesConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeetingFeaturesConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #meetingFeatures(MeetingFeaturesConfiguration)}.
         * 
         * @param meetingFeatures
         *        a consumer that will call methods on {@link MeetingFeaturesConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meetingFeatures(MeetingFeaturesConfiguration)
         */
        default Builder meetingFeatures(Consumer<MeetingFeaturesConfiguration.Builder> meetingFeatures) {
            return meetingFeatures(MeetingFeaturesConfiguration.builder().applyMutation(meetingFeatures).build());
        }

        /**
         * <p>
         * When specified, replicates the media from the primary meeting to this meeting.
         * </p>
         * 
         * @param primaryMeetingId
         *        When specified, replicates the media from the primary meeting to this meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryMeetingId(String primaryMeetingId);

        /**
         * <p>
         * Array of strings.
         * </p>
         * 
         * @param tenantIds
         *        Array of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantIds(Collection<String> tenantIds);

        /**
         * <p>
         * Array of strings.
         * </p>
         * 
         * @param tenantIds
         *        Array of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantIds(String... tenantIds);

        /**
         * <p>
         * The ARN of the meeting.
         * </p>
         * 
         * @param meetingArn
         *        The ARN of the meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingArn(String meetingArn);
    }

    static final class BuilderImpl implements Builder {
        private String meetingId;

        private String meetingHostId;

        private String externalMeetingId;

        private String mediaRegion;

        private MediaPlacement mediaPlacement;

        private MeetingFeaturesConfiguration meetingFeatures;

        private String primaryMeetingId;

        private List<String> tenantIds = DefaultSdkAutoConstructList.getInstance();

        private String meetingArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Meeting model) {
            meetingId(model.meetingId);
            meetingHostId(model.meetingHostId);
            externalMeetingId(model.externalMeetingId);
            mediaRegion(model.mediaRegion);
            mediaPlacement(model.mediaPlacement);
            meetingFeatures(model.meetingFeatures);
            primaryMeetingId(model.primaryMeetingId);
            tenantIds(model.tenantIds);
            meetingArn(model.meetingArn);
        }

        public final String getMeetingId() {
            return meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final String getMeetingHostId() {
            return meetingHostId;
        }

        public final void setMeetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
        }

        @Override
        public final Builder meetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
            return this;
        }

        public final String getExternalMeetingId() {
            return externalMeetingId;
        }

        public final void setExternalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
        }

        @Override
        public final Builder externalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
            return this;
        }

        public final String getMediaRegion() {
            return mediaRegion;
        }

        public final void setMediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
        }

        @Override
        public final Builder mediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
            return this;
        }

        public final MediaPlacement.Builder getMediaPlacement() {
            return mediaPlacement != null ? mediaPlacement.toBuilder() : null;
        }

        public final void setMediaPlacement(MediaPlacement.BuilderImpl mediaPlacement) {
            this.mediaPlacement = mediaPlacement != null ? mediaPlacement.build() : null;
        }

        @Override
        public final Builder mediaPlacement(MediaPlacement mediaPlacement) {
            this.mediaPlacement = mediaPlacement;
            return this;
        }

        public final MeetingFeaturesConfiguration.Builder getMeetingFeatures() {
            return meetingFeatures != null ? meetingFeatures.toBuilder() : null;
        }

        public final void setMeetingFeatures(MeetingFeaturesConfiguration.BuilderImpl meetingFeatures) {
            this.meetingFeatures = meetingFeatures != null ? meetingFeatures.build() : null;
        }

        @Override
        public final Builder meetingFeatures(MeetingFeaturesConfiguration meetingFeatures) {
            this.meetingFeatures = meetingFeatures;
            return this;
        }

        public final String getPrimaryMeetingId() {
            return primaryMeetingId;
        }

        public final void setPrimaryMeetingId(String primaryMeetingId) {
            this.primaryMeetingId = primaryMeetingId;
        }

        @Override
        public final Builder primaryMeetingId(String primaryMeetingId) {
            this.primaryMeetingId = primaryMeetingId;
            return this;
        }

        public final Collection<String> getTenantIds() {
            if (tenantIds instanceof SdkAutoConstructList) {
                return null;
            }
            return tenantIds;
        }

        public final void setTenantIds(Collection<String> tenantIds) {
            this.tenantIds = TenantIdListCopier.copy(tenantIds);
        }

        @Override
        public final Builder tenantIds(Collection<String> tenantIds) {
            this.tenantIds = TenantIdListCopier.copy(tenantIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tenantIds(String... tenantIds) {
            tenantIds(Arrays.asList(tenantIds));
            return this;
        }

        public final String getMeetingArn() {
            return meetingArn;
        }

        public final void setMeetingArn(String meetingArn) {
            this.meetingArn = meetingArn;
        }

        @Override
        public final Builder meetingArn(String meetingArn) {
            this.meetingArn = meetingArn;
            return this;
        }

        @Override
        public Meeting build() {
            return new Meeting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
