/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmeetings.model.ChimeSdkMeetingsRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequestItem;
import software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequestItemListCopier;
import software.amazon.awssdk.services.chimesdkmeetings.model.MeetingFeaturesConfiguration;
import software.amazon.awssdk.services.chimesdkmeetings.model.NotificationsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMeetingWithAttendeesRequest
extends ChimeSdkMeetingsRequest
implements ToCopyableBuilder<Builder, CreateMeetingWithAttendeesRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::clientRequestToken)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> MEDIA_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaRegion").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::mediaRegion)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::mediaRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaRegion").build()}).build();
    private static final SdkField<String> MEETING_HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeetingHostId").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::meetingHostId)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::meetingHostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingHostId").build()}).build();
    private static final SdkField<String> EXTERNAL_MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalMeetingId").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::externalMeetingId)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::externalMeetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalMeetingId").build()}).build();
    private static final SdkField<MeetingFeaturesConfiguration> MEETING_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MeetingFeatures").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::meetingFeatures)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::meetingFeatures)).constructor(MeetingFeaturesConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingFeatures").build()}).build();
    private static final SdkField<NotificationsConfiguration> NOTIFICATIONS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationsConfiguration").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::notificationsConfiguration)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::notificationsConfiguration)).constructor(NotificationsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationsConfiguration").build()}).build();
    private static final SdkField<List<CreateAttendeeRequestItem>> ATTENDEES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attendees").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::attendees)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::attendees)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendees").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateAttendeeRequestItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRIMARY_MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryMeetingId").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::primaryMeetingId)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::primaryMeetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryMeetingId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, MEDIA_REGION_FIELD, MEETING_HOST_ID_FIELD, EXTERNAL_MEETING_ID_FIELD, MEETING_FEATURES_FIELD, NOTIFICATIONS_CONFIGURATION_FIELD, ATTENDEES_FIELD, PRIMARY_MEETING_ID_FIELD));
    private final String clientRequestToken;
    private final String mediaRegion;
    private final String meetingHostId;
    private final String externalMeetingId;
    private final MeetingFeaturesConfiguration meetingFeatures;
    private final NotificationsConfiguration notificationsConfiguration;
    private final List<CreateAttendeeRequestItem> attendees;
    private final String primaryMeetingId;

    private CreateMeetingWithAttendeesRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.mediaRegion = builder.mediaRegion;
        this.meetingHostId = builder.meetingHostId;
        this.externalMeetingId = builder.externalMeetingId;
        this.meetingFeatures = builder.meetingFeatures;
        this.notificationsConfiguration = builder.notificationsConfiguration;
        this.attendees = builder.attendees;
        this.primaryMeetingId = builder.primaryMeetingId;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String mediaRegion() {
        return this.mediaRegion;
    }

    public final String meetingHostId() {
        return this.meetingHostId;
    }

    public final String externalMeetingId() {
        return this.externalMeetingId;
    }

    public final MeetingFeaturesConfiguration meetingFeatures() {
        return this.meetingFeatures;
    }

    public final NotificationsConfiguration notificationsConfiguration() {
        return this.notificationsConfiguration;
    }

    public final boolean hasAttendees() {
        return this.attendees != null && !(this.attendees instanceof SdkAutoConstructList);
    }

    public final List<CreateAttendeeRequestItem> attendees() {
        return this.attendees;
    }

    public final String primaryMeetingId() {
        return this.primaryMeetingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingHostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalMeetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttendees() ? this.attendees() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryMeetingId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeetingWithAttendeesRequest)) {
            return false;
        }
        CreateMeetingWithAttendeesRequest other = (CreateMeetingWithAttendeesRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.mediaRegion(), other.mediaRegion()) && Objects.equals(this.meetingHostId(), other.meetingHostId()) && Objects.equals(this.externalMeetingId(), other.externalMeetingId()) && Objects.equals(this.meetingFeatures(), other.meetingFeatures()) && Objects.equals(this.notificationsConfiguration(), other.notificationsConfiguration()) && this.hasAttendees() == other.hasAttendees() && Objects.equals(this.attendees(), other.attendees()) && Objects.equals(this.primaryMeetingId(), other.primaryMeetingId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMeetingWithAttendeesRequest").add("ClientRequestToken", (Object)(this.clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")).add("MediaRegion", (Object)this.mediaRegion()).add("MeetingHostId", (Object)(this.meetingHostId() == null ? null : "*** Sensitive Data Redacted ***")).add("ExternalMeetingId", (Object)(this.externalMeetingId() == null ? null : "*** Sensitive Data Redacted ***")).add("MeetingFeatures", (Object)this.meetingFeatures()).add("NotificationsConfiguration", (Object)this.notificationsConfiguration()).add("Attendees", this.hasAttendees() ? this.attendees() : null).add("PrimaryMeetingId", (Object)this.primaryMeetingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "MediaRegion": {
                return Optional.ofNullable(clazz.cast(this.mediaRegion()));
            }
            case "MeetingHostId": {
                return Optional.ofNullable(clazz.cast(this.meetingHostId()));
            }
            case "ExternalMeetingId": {
                return Optional.ofNullable(clazz.cast(this.externalMeetingId()));
            }
            case "MeetingFeatures": {
                return Optional.ofNullable(clazz.cast(this.meetingFeatures()));
            }
            case "NotificationsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.notificationsConfiguration()));
            }
            case "Attendees": {
                return Optional.ofNullable(clazz.cast(this.attendees()));
            }
            case "PrimaryMeetingId": {
                return Optional.ofNullable(clazz.cast(this.primaryMeetingId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMeetingWithAttendeesRequest, T> g) {
        return obj -> g.apply((CreateMeetingWithAttendeesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMeetingsRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String mediaRegion;
        private String meetingHostId;
        private String externalMeetingId;
        private MeetingFeaturesConfiguration meetingFeatures;
        private NotificationsConfiguration notificationsConfiguration;
        private List<CreateAttendeeRequestItem> attendees = DefaultSdkAutoConstructList.getInstance();
        private String primaryMeetingId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMeetingWithAttendeesRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.mediaRegion(model.mediaRegion);
            this.meetingHostId(model.meetingHostId);
            this.externalMeetingId(model.externalMeetingId);
            this.meetingFeatures(model.meetingFeatures);
            this.notificationsConfiguration(model.notificationsConfiguration);
            this.attendees(model.attendees);
            this.primaryMeetingId(model.primaryMeetingId);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getMediaRegion() {
            return this.mediaRegion;
        }

        public final void setMediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
        }

        @Override
        @Transient
        public final Builder mediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
            return this;
        }

        public final String getMeetingHostId() {
            return this.meetingHostId;
        }

        public final void setMeetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
        }

        @Override
        @Transient
        public final Builder meetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
            return this;
        }

        public final String getExternalMeetingId() {
            return this.externalMeetingId;
        }

        public final void setExternalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
        }

        @Override
        @Transient
        public final Builder externalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
            return this;
        }

        public final MeetingFeaturesConfiguration.Builder getMeetingFeatures() {
            return this.meetingFeatures != null ? this.meetingFeatures.toBuilder() : null;
        }

        public final void setMeetingFeatures(MeetingFeaturesConfiguration.BuilderImpl meetingFeatures) {
            this.meetingFeatures = meetingFeatures != null ? meetingFeatures.build() : null;
        }

        @Override
        @Transient
        public final Builder meetingFeatures(MeetingFeaturesConfiguration meetingFeatures) {
            this.meetingFeatures = meetingFeatures;
            return this;
        }

        public final NotificationsConfiguration.Builder getNotificationsConfiguration() {
            return this.notificationsConfiguration != null ? this.notificationsConfiguration.toBuilder() : null;
        }

        public final void setNotificationsConfiguration(NotificationsConfiguration.BuilderImpl notificationsConfiguration) {
            this.notificationsConfiguration = notificationsConfiguration != null ? notificationsConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder notificationsConfiguration(NotificationsConfiguration notificationsConfiguration) {
            this.notificationsConfiguration = notificationsConfiguration;
            return this;
        }

        public final List<CreateAttendeeRequestItem.Builder> getAttendees() {
            List<CreateAttendeeRequestItem.Builder> result = CreateMeetingWithAttendeesRequestItemListCopier.copyToBuilder(this.attendees);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttendees(Collection<CreateAttendeeRequestItem.BuilderImpl> attendees) {
            this.attendees = CreateMeetingWithAttendeesRequestItemListCopier.copyFromBuilder(attendees);
        }

        @Override
        @Transient
        public final Builder attendees(Collection<CreateAttendeeRequestItem> attendees) {
            this.attendees = CreateMeetingWithAttendeesRequestItemListCopier.copy(attendees);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attendees(CreateAttendeeRequestItem ... attendees) {
            this.attendees(Arrays.asList(attendees));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attendees(Consumer<CreateAttendeeRequestItem.Builder> ... attendees) {
            this.attendees(Stream.of(attendees).map(c -> (CreateAttendeeRequestItem)((CreateAttendeeRequestItem.Builder)CreateAttendeeRequestItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPrimaryMeetingId() {
            return this.primaryMeetingId;
        }

        public final void setPrimaryMeetingId(String primaryMeetingId) {
            this.primaryMeetingId = primaryMeetingId;
        }

        @Override
        @Transient
        public final Builder primaryMeetingId(String primaryMeetingId) {
            this.primaryMeetingId = primaryMeetingId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMeetingWithAttendeesRequest build() {
            return new CreateMeetingWithAttendeesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkMeetingsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMeetingWithAttendeesRequest> {
        public Builder clientRequestToken(String var1);

        public Builder mediaRegion(String var1);

        public Builder meetingHostId(String var1);

        public Builder externalMeetingId(String var1);

        public Builder meetingFeatures(MeetingFeaturesConfiguration var1);

        default public Builder meetingFeatures(Consumer<MeetingFeaturesConfiguration.Builder> meetingFeatures) {
            return this.meetingFeatures((MeetingFeaturesConfiguration)((MeetingFeaturesConfiguration.Builder)MeetingFeaturesConfiguration.builder().applyMutation(meetingFeatures)).build());
        }

        public Builder notificationsConfiguration(NotificationsConfiguration var1);

        default public Builder notificationsConfiguration(Consumer<NotificationsConfiguration.Builder> notificationsConfiguration) {
            return this.notificationsConfiguration((NotificationsConfiguration)((NotificationsConfiguration.Builder)NotificationsConfiguration.builder().applyMutation(notificationsConfiguration)).build());
        }

        public Builder attendees(Collection<CreateAttendeeRequestItem> var1);

        public Builder attendees(CreateAttendeeRequestItem ... var1);

        public Builder attendees(Consumer<CreateAttendeeRequestItem.Builder> ... var1);

        public Builder primaryMeetingId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

