/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeContentIdentificationType;
import software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeContentRedactionType;
import software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeLanguageCode;
import software.amazon.awssdk.services.chimesdkmeetings.model.TranscribePartialResultsStability;
import software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion;
import software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeVocabularyFilterMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EngineTranscribeSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EngineTranscribeSettings> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::languageCodeAsString)).setter(EngineTranscribeSettings.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterMethod").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::vocabularyFilterMethodAsString)).setter(EngineTranscribeSettings.setter(Builder::vocabularyFilterMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterName").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::vocabularyFilterName)).setter(EngineTranscribeSettings.setter(Builder::vocabularyFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build()}).build();
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::vocabularyName)).setter(EngineTranscribeSettings.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::regionAsString)).setter(EngineTranscribeSettings.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<Boolean> ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePartialResultsStabilization").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::enablePartialResultsStabilization)).setter(EngineTranscribeSettings.setter(Builder::enablePartialResultsStabilization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePartialResultsStabilization").build()}).build();
    private static final SdkField<String> PARTIAL_RESULTS_STABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartialResultsStability").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::partialResultsStabilityAsString)).setter(EngineTranscribeSettings.setter(Builder::partialResultsStability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartialResultsStability").build()}).build();
    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentIdentificationType").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::contentIdentificationTypeAsString)).setter(EngineTranscribeSettings.setter(Builder::contentIdentificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentIdentificationType").build()}).build();
    private static final SdkField<String> CONTENT_REDACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentRedactionType").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::contentRedactionTypeAsString)).setter(EngineTranscribeSettings.setter(Builder::contentRedactionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedactionType").build()}).build();
    private static final SdkField<String> PII_ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PiiEntityTypes").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::piiEntityTypes)).setter(EngineTranscribeSettings.setter(Builder::piiEntityTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PiiEntityTypes").build()}).build();
    private static final SdkField<String> LANGUAGE_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageModelName").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::languageModelName)).setter(EngineTranscribeSettings.setter(Builder::languageModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageModelName").build()}).build();
    private static final SdkField<Boolean> IDENTIFY_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IdentifyLanguage").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::identifyLanguage)).setter(EngineTranscribeSettings.setter(Builder::identifyLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifyLanguage").build()}).build();
    private static final SdkField<String> LANGUAGE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageOptions").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::languageOptions)).setter(EngineTranscribeSettings.setter(Builder::languageOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageOptions").build()}).build();
    private static final SdkField<String> PREFERRED_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredLanguage").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::preferredLanguageAsString)).setter(EngineTranscribeSettings.setter(Builder::preferredLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredLanguage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD, VOCABULARY_FILTER_METHOD_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_NAME_FIELD, REGION_FIELD, ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD, PARTIAL_RESULTS_STABILITY_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD, CONTENT_REDACTION_TYPE_FIELD, PII_ENTITY_TYPES_FIELD, LANGUAGE_MODEL_NAME_FIELD, IDENTIFY_LANGUAGE_FIELD, LANGUAGE_OPTIONS_FIELD, PREFERRED_LANGUAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String languageCode;
    private final String vocabularyFilterMethod;
    private final String vocabularyFilterName;
    private final String vocabularyName;
    private final String region;
    private final Boolean enablePartialResultsStabilization;
    private final String partialResultsStability;
    private final String contentIdentificationType;
    private final String contentRedactionType;
    private final String piiEntityTypes;
    private final String languageModelName;
    private final Boolean identifyLanguage;
    private final String languageOptions;
    private final String preferredLanguage;

    private EngineTranscribeSettings(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyName = builder.vocabularyName;
        this.region = builder.region;
        this.enablePartialResultsStabilization = builder.enablePartialResultsStabilization;
        this.partialResultsStability = builder.partialResultsStability;
        this.contentIdentificationType = builder.contentIdentificationType;
        this.contentRedactionType = builder.contentRedactionType;
        this.piiEntityTypes = builder.piiEntityTypes;
        this.languageModelName = builder.languageModelName;
        this.identifyLanguage = builder.identifyLanguage;
        this.languageOptions = builder.languageOptions;
        this.preferredLanguage = builder.preferredLanguage;
    }

    public final TranscribeLanguageCode languageCode() {
        return TranscribeLanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final TranscribeVocabularyFilterMethod vocabularyFilterMethod() {
        return TranscribeVocabularyFilterMethod.fromValue(this.vocabularyFilterMethod);
    }

    public final String vocabularyFilterMethodAsString() {
        return this.vocabularyFilterMethod;
    }

    public final String vocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final TranscribeRegion region() {
        return TranscribeRegion.fromValue(this.region);
    }

    public final String regionAsString() {
        return this.region;
    }

    public final Boolean enablePartialResultsStabilization() {
        return this.enablePartialResultsStabilization;
    }

    public final TranscribePartialResultsStability partialResultsStability() {
        return TranscribePartialResultsStability.fromValue(this.partialResultsStability);
    }

    public final String partialResultsStabilityAsString() {
        return this.partialResultsStability;
    }

    public final TranscribeContentIdentificationType contentIdentificationType() {
        return TranscribeContentIdentificationType.fromValue(this.contentIdentificationType);
    }

    public final String contentIdentificationTypeAsString() {
        return this.contentIdentificationType;
    }

    public final TranscribeContentRedactionType contentRedactionType() {
        return TranscribeContentRedactionType.fromValue(this.contentRedactionType);
    }

    public final String contentRedactionTypeAsString() {
        return this.contentRedactionType;
    }

    public final String piiEntityTypes() {
        return this.piiEntityTypes;
    }

    public final String languageModelName() {
        return this.languageModelName;
    }

    public final Boolean identifyLanguage() {
        return this.identifyLanguage;
    }

    public final String languageOptions() {
        return this.languageOptions;
    }

    public final TranscribeLanguageCode preferredLanguage() {
        return TranscribeLanguageCode.fromValue(this.preferredLanguage);
    }

    public final String preferredLanguageAsString() {
        return this.preferredLanguage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePartialResultsStabilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.partialResultsStabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentIdentificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRedactionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.piiEntityTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifyLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredLanguageAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineTranscribeSettings)) {
            return false;
        }
        EngineTranscribeSettings other = (EngineTranscribeSettings)obj;
        return Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString()) && Objects.equals(this.vocabularyFilterName(), other.vocabularyFilterName()) && Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.regionAsString(), other.regionAsString()) && Objects.equals(this.enablePartialResultsStabilization(), other.enablePartialResultsStabilization()) && Objects.equals(this.partialResultsStabilityAsString(), other.partialResultsStabilityAsString()) && Objects.equals(this.contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString()) && Objects.equals(this.contentRedactionTypeAsString(), other.contentRedactionTypeAsString()) && Objects.equals(this.piiEntityTypes(), other.piiEntityTypes()) && Objects.equals(this.languageModelName(), other.languageModelName()) && Objects.equals(this.identifyLanguage(), other.identifyLanguage()) && Objects.equals(this.languageOptions(), other.languageOptions()) && Objects.equals(this.preferredLanguageAsString(), other.preferredLanguageAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EngineTranscribeSettings").add("LanguageCode", (Object)this.languageCodeAsString()).add("VocabularyFilterMethod", (Object)this.vocabularyFilterMethodAsString()).add("VocabularyFilterName", (Object)this.vocabularyFilterName()).add("VocabularyName", (Object)this.vocabularyName()).add("Region", (Object)this.regionAsString()).add("EnablePartialResultsStabilization", (Object)this.enablePartialResultsStabilization()).add("PartialResultsStability", (Object)this.partialResultsStabilityAsString()).add("ContentIdentificationType", (Object)this.contentIdentificationTypeAsString()).add("ContentRedactionType", (Object)this.contentRedactionTypeAsString()).add("PiiEntityTypes", (Object)this.piiEntityTypes()).add("LanguageModelName", (Object)this.languageModelName()).add("IdentifyLanguage", (Object)this.identifyLanguage()).add("LanguageOptions", (Object)this.languageOptions()).add("PreferredLanguage", (Object)this.preferredLanguageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "VocabularyFilterMethod": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMethodAsString()));
            }
            case "VocabularyFilterName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterName()));
            }
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.regionAsString()));
            }
            case "EnablePartialResultsStabilization": {
                return Optional.ofNullable(clazz.cast(this.enablePartialResultsStabilization()));
            }
            case "PartialResultsStability": {
                return Optional.ofNullable(clazz.cast(this.partialResultsStabilityAsString()));
            }
            case "ContentIdentificationType": {
                return Optional.ofNullable(clazz.cast(this.contentIdentificationTypeAsString()));
            }
            case "ContentRedactionType": {
                return Optional.ofNullable(clazz.cast(this.contentRedactionTypeAsString()));
            }
            case "PiiEntityTypes": {
                return Optional.ofNullable(clazz.cast(this.piiEntityTypes()));
            }
            case "LanguageModelName": {
                return Optional.ofNullable(clazz.cast(this.languageModelName()));
            }
            case "IdentifyLanguage": {
                return Optional.ofNullable(clazz.cast(this.identifyLanguage()));
            }
            case "LanguageOptions": {
                return Optional.ofNullable(clazz.cast(this.languageOptions()));
            }
            case "PreferredLanguage": {
                return Optional.ofNullable(clazz.cast(this.preferredLanguageAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EngineTranscribeSettings, T> g) {
        return obj -> g.apply((EngineTranscribeSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String languageCode;
        private String vocabularyFilterMethod;
        private String vocabularyFilterName;
        private String vocabularyName;
        private String region;
        private Boolean enablePartialResultsStabilization;
        private String partialResultsStability;
        private String contentIdentificationType;
        private String contentRedactionType;
        private String piiEntityTypes;
        private String languageModelName;
        private Boolean identifyLanguage;
        private String languageOptions;
        private String preferredLanguage;

        private BuilderImpl() {
        }

        private BuilderImpl(EngineTranscribeSettings model) {
            this.languageCode(model.languageCode);
            this.vocabularyFilterMethod(model.vocabularyFilterMethod);
            this.vocabularyFilterName(model.vocabularyFilterName);
            this.vocabularyName(model.vocabularyName);
            this.region(model.region);
            this.enablePartialResultsStabilization(model.enablePartialResultsStabilization);
            this.partialResultsStability(model.partialResultsStability);
            this.contentIdentificationType(model.contentIdentificationType);
            this.contentRedactionType(model.contentRedactionType);
            this.piiEntityTypes(model.piiEntityTypes);
            this.languageModelName(model.languageModelName);
            this.identifyLanguage(model.identifyLanguage);
            this.languageOptions(model.languageOptions);
            this.preferredLanguage(model.preferredLanguage);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(TranscribeLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return this.vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterMethod(TranscribeVocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final String getVocabularyFilterName() {
            return this.vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        @Transient
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        @Transient
        public final Builder region(TranscribeRegion region) {
            this.region(region == null ? null : region.toString());
            return this;
        }

        public final Boolean getEnablePartialResultsStabilization() {
            return this.enablePartialResultsStabilization;
        }

        public final void setEnablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
        }

        @Override
        @Transient
        public final Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
            return this;
        }

        public final String getPartialResultsStability() {
            return this.partialResultsStability;
        }

        public final void setPartialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
        }

        @Override
        @Transient
        public final Builder partialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
            return this;
        }

        @Override
        @Transient
        public final Builder partialResultsStability(TranscribePartialResultsStability partialResultsStability) {
            this.partialResultsStability(partialResultsStability == null ? null : partialResultsStability.toString());
            return this;
        }

        public final String getContentIdentificationType() {
            return this.contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        @Transient
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        @Transient
        public final Builder contentIdentificationType(TranscribeContentIdentificationType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        public final String getContentRedactionType() {
            return this.contentRedactionType;
        }

        public final void setContentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
        }

        @Override
        @Transient
        public final Builder contentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
            return this;
        }

        @Override
        @Transient
        public final Builder contentRedactionType(TranscribeContentRedactionType contentRedactionType) {
            this.contentRedactionType(contentRedactionType == null ? null : contentRedactionType.toString());
            return this;
        }

        public final String getPiiEntityTypes() {
            return this.piiEntityTypes;
        }

        public final void setPiiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
        }

        @Override
        @Transient
        public final Builder piiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
            return this;
        }

        public final String getLanguageModelName() {
            return this.languageModelName;
        }

        public final void setLanguageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
        }

        @Override
        @Transient
        public final Builder languageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
            return this;
        }

        public final Boolean getIdentifyLanguage() {
            return this.identifyLanguage;
        }

        public final void setIdentifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
        }

        @Override
        @Transient
        public final Builder identifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
            return this;
        }

        public final String getLanguageOptions() {
            return this.languageOptions;
        }

        public final void setLanguageOptions(String languageOptions) {
            this.languageOptions = languageOptions;
        }

        @Override
        @Transient
        public final Builder languageOptions(String languageOptions) {
            this.languageOptions = languageOptions;
            return this;
        }

        public final String getPreferredLanguage() {
            return this.preferredLanguage;
        }

        public final void setPreferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
        }

        @Override
        @Transient
        public final Builder preferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            return this;
        }

        @Override
        @Transient
        public final Builder preferredLanguage(TranscribeLanguageCode preferredLanguage) {
            this.preferredLanguage(preferredLanguage == null ? null : preferredLanguage.toString());
            return this;
        }

        public EngineTranscribeSettings build() {
            return new EngineTranscribeSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EngineTranscribeSettings> {
        public Builder languageCode(String var1);

        public Builder languageCode(TranscribeLanguageCode var1);

        public Builder vocabularyFilterMethod(String var1);

        public Builder vocabularyFilterMethod(TranscribeVocabularyFilterMethod var1);

        public Builder vocabularyFilterName(String var1);

        public Builder vocabularyName(String var1);

        public Builder region(String var1);

        public Builder region(TranscribeRegion var1);

        public Builder enablePartialResultsStabilization(Boolean var1);

        public Builder partialResultsStability(String var1);

        public Builder partialResultsStability(TranscribePartialResultsStability var1);

        public Builder contentIdentificationType(String var1);

        public Builder contentIdentificationType(TranscribeContentIdentificationType var1);

        public Builder contentRedactionType(String var1);

        public Builder contentRedactionType(TranscribeContentRedactionType var1);

        public Builder piiEntityTypes(String var1);

        public Builder languageModelName(String var1);

        public Builder identifyLanguage(Boolean var1);

        public Builder languageOptions(String var1);

        public Builder preferredLanguage(String var1);

        public Builder preferredLanguage(TranscribeLanguageCode var1);
    }
}

