/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineStatus;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSink;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSinkListCopier;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSource;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaStreamPipeline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaStreamPipeline> {
    private static final SdkField<String> MEDIA_PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaPipelineId").getter(MediaStreamPipeline.getter(MediaStreamPipeline::mediaPipelineId)).setter(MediaStreamPipeline.setter(Builder::mediaPipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelineId").build()}).build();
    private static final SdkField<String> MEDIA_PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaPipelineArn").getter(MediaStreamPipeline.getter(MediaStreamPipeline::mediaPipelineArn)).setter(MediaStreamPipeline.setter(Builder::mediaPipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelineArn").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(MediaStreamPipeline.getter(MediaStreamPipeline::createdTimestamp)).setter(MediaStreamPipeline.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(MediaStreamPipeline.getter(MediaStreamPipeline::updatedTimestamp)).setter(MediaStreamPipeline.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MediaStreamPipeline.getter(MediaStreamPipeline::statusAsString)).setter(MediaStreamPipeline.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<MediaStreamSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(MediaStreamPipeline.getter(MediaStreamPipeline::sources)).setter(MediaStreamPipeline.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaStreamSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MediaStreamSink>> SINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sinks").getter(MediaStreamPipeline.getter(MediaStreamPipeline::sinks)).setter(MediaStreamPipeline.setter(Builder::sinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaStreamSink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_PIPELINE_ID_FIELD, MEDIA_PIPELINE_ARN_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD, STATUS_FIELD, SOURCES_FIELD, SINKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaStreamPipeline.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mediaPipelineId;
    private final String mediaPipelineArn;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;
    private final String status;
    private final List<MediaStreamSource> sources;
    private final List<MediaStreamSink> sinks;

    private MediaStreamPipeline(BuilderImpl builder) {
        this.mediaPipelineId = builder.mediaPipelineId;
        this.mediaPipelineArn = builder.mediaPipelineArn;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.status = builder.status;
        this.sources = builder.sources;
        this.sinks = builder.sinks;
    }

    public final String mediaPipelineId() {
        return this.mediaPipelineId;
    }

    public final String mediaPipelineArn() {
        return this.mediaPipelineArn;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public final MediaPipelineStatus status() {
        return MediaPipelineStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<MediaStreamSource> sources() {
        return this.sources;
    }

    public final boolean hasSinks() {
        return this.sinks != null && !(this.sinks instanceof SdkAutoConstructList);
    }

    public final List<MediaStreamSink> sinks() {
        return this.sinks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSinks() ? this.sinks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStreamPipeline)) {
            return false;
        }
        MediaStreamPipeline other = (MediaStreamPipeline)obj;
        return Objects.equals(this.mediaPipelineId(), other.mediaPipelineId()) && Objects.equals(this.mediaPipelineArn(), other.mediaPipelineArn()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && this.hasSinks() == other.hasSinks() && Objects.equals(this.sinks(), other.sinks());
    }

    public final String toString() {
        return ToString.builder((String)"MediaStreamPipeline").add("MediaPipelineId", (Object)this.mediaPipelineId()).add("MediaPipelineArn", (Object)this.mediaPipelineArn()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).add("Status", (Object)this.statusAsString()).add("Sources", this.hasSources() ? this.sources() : null).add("Sinks", this.hasSinks() ? this.sinks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaPipelineId": {
                return Optional.ofNullable(clazz.cast(this.mediaPipelineId()));
            }
            case "MediaPipelineArn": {
                return Optional.ofNullable(clazz.cast(this.mediaPipelineArn()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "Sinks": {
                return Optional.ofNullable(clazz.cast(this.sinks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MediaPipelineId", MEDIA_PIPELINE_ID_FIELD);
        map.put("MediaPipelineArn", MEDIA_PIPELINE_ARN_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Sources", SOURCES_FIELD);
        map.put("Sinks", SINKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaStreamPipeline, T> g) {
        return obj -> g.apply((MediaStreamPipeline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mediaPipelineId;
        private String mediaPipelineArn;
        private Instant createdTimestamp;
        private Instant updatedTimestamp;
        private String status;
        private List<MediaStreamSource> sources = DefaultSdkAutoConstructList.getInstance();
        private List<MediaStreamSink> sinks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MediaStreamPipeline model) {
            this.mediaPipelineId(model.mediaPipelineId);
            this.mediaPipelineArn(model.mediaPipelineArn);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
            this.status(model.status);
            this.sources(model.sources);
            this.sinks(model.sinks);
        }

        public final String getMediaPipelineId() {
            return this.mediaPipelineId;
        }

        public final void setMediaPipelineId(String mediaPipelineId) {
            this.mediaPipelineId = mediaPipelineId;
        }

        @Override
        public final Builder mediaPipelineId(String mediaPipelineId) {
            this.mediaPipelineId = mediaPipelineId;
            return this;
        }

        public final String getMediaPipelineArn() {
            return this.mediaPipelineArn;
        }

        public final void setMediaPipelineArn(String mediaPipelineArn) {
            this.mediaPipelineArn = mediaPipelineArn;
        }

        @Override
        public final Builder mediaPipelineArn(String mediaPipelineArn) {
            this.mediaPipelineArn = mediaPipelineArn;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MediaPipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<MediaStreamSource.Builder> getSources() {
            List<MediaStreamSource.Builder> result = MediaStreamSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<MediaStreamSource.BuilderImpl> sources) {
            this.sources = MediaStreamSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<MediaStreamSource> sources) {
            this.sources = MediaStreamSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(MediaStreamSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<MediaStreamSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (MediaStreamSource)((MediaStreamSource.Builder)MediaStreamSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MediaStreamSink.Builder> getSinks() {
            List<MediaStreamSink.Builder> result = MediaStreamSinkListCopier.copyToBuilder(this.sinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSinks(Collection<MediaStreamSink.BuilderImpl> sinks) {
            this.sinks = MediaStreamSinkListCopier.copyFromBuilder(sinks);
        }

        @Override
        public final Builder sinks(Collection<MediaStreamSink> sinks) {
            this.sinks = MediaStreamSinkListCopier.copy(sinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(MediaStreamSink ... sinks) {
            this.sinks(Arrays.asList(sinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(Consumer<MediaStreamSink.Builder> ... sinks) {
            this.sinks(Stream.of(sinks).map(c -> (MediaStreamSink)((MediaStreamSink.Builder)MediaStreamSink.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MediaStreamPipeline build() {
            return new MediaStreamPipeline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaStreamPipeline> {
        public Builder mediaPipelineId(String var1);

        public Builder mediaPipelineArn(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(MediaPipelineStatus var1);

        public Builder sources(Collection<MediaStreamSource> var1);

        public Builder sources(MediaStreamSource ... var1);

        public Builder sources(Consumer<MediaStreamSource.Builder> ... var1);

        public Builder sinks(Collection<MediaStreamSink> var1);

        public Builder sinks(MediaStreamSink ... var1);

        public Builder sinks(Consumer<MediaStreamSink.Builder> ... var1);
    }
}

