/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CallAnalyticsLanguageCode;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CategoryNameListCopier;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ContentType;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.PartialResultsStability;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.PostCallAnalyticsSettings;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.VocabularyFilterMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmazonTranscribeCallAnalyticsProcessorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmazonTranscribeCallAnalyticsProcessorConfiguration> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(AmazonTranscribeCallAnalyticsProcessorConfiguration.getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::languageCodeAsString)).setter(AmazonTranscribeCallAnalyticsProcessorConfiguration.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(AmazonTranscribeCallAnalyticsProcessorConfiguration.getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::vocabularyName)).setter(AmazonTranscribeCallAnalyticsProcessorConfiguration.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterName").getter(AmazonTranscribeCallAnalyticsProcessorConfiguration.getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::vocabularyFilterName)).setter(AmazonTranscribeCallAnalyticsProcessorConfiguration.setter(Builder::vocabularyFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterMethod").getter(AmazonTranscribeCallAnalyticsProcessorConfiguration.getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::vocabularyFilterMethodAsString)).setter(AmazonTranscribeCallAnalyticsProcessorConfiguration.setter(Builder::vocabularyFilterMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build()}).build();
    private static final SdkField<String> LANGUAGE_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageModelName").getter(AmazonTranscribeCallAnalyticsProcessorConfiguration.getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::languageModelName)).setter(AmazonTranscribeCallAnalyticsProcessorConfiguration.setter(Builder::languageModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageModelName").build()}).build();
    private static final SdkField<Boolean> ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePartialResultsStabilization").getter(AmazonTranscribeCallAnalyticsProcessorConfiguration.getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::enablePartialResultsStabilization)).setter(AmazonTranscribeCallAnalyticsProcessorConfiguration.setter(Builder::enablePartialResultsStabilization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePartialResultsStabilization").build()}).build();
    private static final SdkField<String> PARTIAL_RESULTS_STABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartialResultsStability").getter(AmazonTranscribeCallAnalyticsProcessorConfiguration.getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::partialResultsStabilityAsString)).setter(AmazonTranscribeCallAnalyticsProcessorConfiguration.setter(Builder::partialResultsStability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartialResultsStability").build()}).build();
    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentIdentificationType").getter(AmazonTranscribeCallAnalyticsProcessorConfiguration.getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::contentIdentificationTypeAsString)).setter(AmazonTranscribeCallAnalyticsProcessorConfiguration.setter(Builder::contentIdentificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentIdentificationType").build()}).build();
    private static final SdkField<String> CONTENT_REDACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentRedactionType").getter(AmazonTranscribeCallAnalyticsProcessorConfiguration.getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::contentRedactionTypeAsString)).setter(AmazonTranscribeCallAnalyticsProcessorConfiguration.setter(Builder::contentRedactionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedactionType").build()}).build();
    private static final SdkField<String> PII_ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PiiEntityTypes").getter(AmazonTranscribeCallAnalyticsProcessorConfiguration.getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::piiEntityTypes)).setter(AmazonTranscribeCallAnalyticsProcessorConfiguration.setter(Builder::piiEntityTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PiiEntityTypes").build()}).build();
    private static final SdkField<Boolean> FILTER_PARTIAL_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FilterPartialResults").getter(AmazonTranscribeCallAnalyticsProcessorConfiguration.getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::filterPartialResults)).setter(AmazonTranscribeCallAnalyticsProcessorConfiguration.setter(Builder::filterPartialResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterPartialResults").build()}).build();
    private static final SdkField<PostCallAnalyticsSettings> POST_CALL_ANALYTICS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PostCallAnalyticsSettings").getter(AmazonTranscribeCallAnalyticsProcessorConfiguration.getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::postCallAnalyticsSettings)).setter(AmazonTranscribeCallAnalyticsProcessorConfiguration.setter(Builder::postCallAnalyticsSettings)).constructor(PostCallAnalyticsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostCallAnalyticsSettings").build()}).build();
    private static final SdkField<List<String>> CALL_ANALYTICS_STREAM_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CallAnalyticsStreamCategories").getter(AmazonTranscribeCallAnalyticsProcessorConfiguration.getter(AmazonTranscribeCallAnalyticsProcessorConfiguration::callAnalyticsStreamCategories)).setter(AmazonTranscribeCallAnalyticsProcessorConfiguration.setter(Builder::callAnalyticsStreamCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsStreamCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD, VOCABULARY_NAME_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, LANGUAGE_MODEL_NAME_FIELD, ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD, PARTIAL_RESULTS_STABILITY_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD, CONTENT_REDACTION_TYPE_FIELD, PII_ENTITY_TYPES_FIELD, FILTER_PARTIAL_RESULTS_FIELD, POST_CALL_ANALYTICS_SETTINGS_FIELD, CALL_ANALYTICS_STREAM_CATEGORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AmazonTranscribeCallAnalyticsProcessorConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String languageCode;
    private final String vocabularyName;
    private final String vocabularyFilterName;
    private final String vocabularyFilterMethod;
    private final String languageModelName;
    private final Boolean enablePartialResultsStabilization;
    private final String partialResultsStability;
    private final String contentIdentificationType;
    private final String contentRedactionType;
    private final String piiEntityTypes;
    private final Boolean filterPartialResults;
    private final PostCallAnalyticsSettings postCallAnalyticsSettings;
    private final List<String> callAnalyticsStreamCategories;

    private AmazonTranscribeCallAnalyticsProcessorConfiguration(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.vocabularyName = builder.vocabularyName;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.languageModelName = builder.languageModelName;
        this.enablePartialResultsStabilization = builder.enablePartialResultsStabilization;
        this.partialResultsStability = builder.partialResultsStability;
        this.contentIdentificationType = builder.contentIdentificationType;
        this.contentRedactionType = builder.contentRedactionType;
        this.piiEntityTypes = builder.piiEntityTypes;
        this.filterPartialResults = builder.filterPartialResults;
        this.postCallAnalyticsSettings = builder.postCallAnalyticsSettings;
        this.callAnalyticsStreamCategories = builder.callAnalyticsStreamCategories;
    }

    public final CallAnalyticsLanguageCode languageCode() {
        return CallAnalyticsLanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final String vocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public final VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(this.vocabularyFilterMethod);
    }

    public final String vocabularyFilterMethodAsString() {
        return this.vocabularyFilterMethod;
    }

    public final String languageModelName() {
        return this.languageModelName;
    }

    public final Boolean enablePartialResultsStabilization() {
        return this.enablePartialResultsStabilization;
    }

    public final PartialResultsStability partialResultsStability() {
        return PartialResultsStability.fromValue(this.partialResultsStability);
    }

    public final String partialResultsStabilityAsString() {
        return this.partialResultsStability;
    }

    public final ContentType contentIdentificationType() {
        return ContentType.fromValue(this.contentIdentificationType);
    }

    public final String contentIdentificationTypeAsString() {
        return this.contentIdentificationType;
    }

    public final ContentType contentRedactionType() {
        return ContentType.fromValue(this.contentRedactionType);
    }

    public final String contentRedactionTypeAsString() {
        return this.contentRedactionType;
    }

    public final String piiEntityTypes() {
        return this.piiEntityTypes;
    }

    public final Boolean filterPartialResults() {
        return this.filterPartialResults;
    }

    public final PostCallAnalyticsSettings postCallAnalyticsSettings() {
        return this.postCallAnalyticsSettings;
    }

    public final boolean hasCallAnalyticsStreamCategories() {
        return this.callAnalyticsStreamCategories != null && !(this.callAnalyticsStreamCategories instanceof SdkAutoConstructList);
    }

    public final List<String> callAnalyticsStreamCategories() {
        return this.callAnalyticsStreamCategories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePartialResultsStabilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.partialResultsStabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentIdentificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRedactionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.piiEntityTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPartialResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.postCallAnalyticsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCallAnalyticsStreamCategories() ? this.callAnalyticsStreamCategories() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonTranscribeCallAnalyticsProcessorConfiguration)) {
            return false;
        }
        AmazonTranscribeCallAnalyticsProcessorConfiguration other = (AmazonTranscribeCallAnalyticsProcessorConfiguration)obj;
        return Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.vocabularyFilterName(), other.vocabularyFilterName()) && Objects.equals(this.vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString()) && Objects.equals(this.languageModelName(), other.languageModelName()) && Objects.equals(this.enablePartialResultsStabilization(), other.enablePartialResultsStabilization()) && Objects.equals(this.partialResultsStabilityAsString(), other.partialResultsStabilityAsString()) && Objects.equals(this.contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString()) && Objects.equals(this.contentRedactionTypeAsString(), other.contentRedactionTypeAsString()) && Objects.equals(this.piiEntityTypes(), other.piiEntityTypes()) && Objects.equals(this.filterPartialResults(), other.filterPartialResults()) && Objects.equals(this.postCallAnalyticsSettings(), other.postCallAnalyticsSettings()) && this.hasCallAnalyticsStreamCategories() == other.hasCallAnalyticsStreamCategories() && Objects.equals(this.callAnalyticsStreamCategories(), other.callAnalyticsStreamCategories());
    }

    public final String toString() {
        return ToString.builder((String)"AmazonTranscribeCallAnalyticsProcessorConfiguration").add("LanguageCode", (Object)this.languageCodeAsString()).add("VocabularyName", (Object)this.vocabularyName()).add("VocabularyFilterName", (Object)this.vocabularyFilterName()).add("VocabularyFilterMethod", (Object)this.vocabularyFilterMethodAsString()).add("LanguageModelName", (Object)this.languageModelName()).add("EnablePartialResultsStabilization", (Object)this.enablePartialResultsStabilization()).add("PartialResultsStability", (Object)this.partialResultsStabilityAsString()).add("ContentIdentificationType", (Object)this.contentIdentificationTypeAsString()).add("ContentRedactionType", (Object)this.contentRedactionTypeAsString()).add("PiiEntityTypes", (Object)this.piiEntityTypes()).add("FilterPartialResults", (Object)this.filterPartialResults()).add("PostCallAnalyticsSettings", (Object)this.postCallAnalyticsSettings()).add("CallAnalyticsStreamCategories", this.hasCallAnalyticsStreamCategories() ? this.callAnalyticsStreamCategories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "VocabularyFilterName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterName()));
            }
            case "VocabularyFilterMethod": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMethodAsString()));
            }
            case "LanguageModelName": {
                return Optional.ofNullable(clazz.cast(this.languageModelName()));
            }
            case "EnablePartialResultsStabilization": {
                return Optional.ofNullable(clazz.cast(this.enablePartialResultsStabilization()));
            }
            case "PartialResultsStability": {
                return Optional.ofNullable(clazz.cast(this.partialResultsStabilityAsString()));
            }
            case "ContentIdentificationType": {
                return Optional.ofNullable(clazz.cast(this.contentIdentificationTypeAsString()));
            }
            case "ContentRedactionType": {
                return Optional.ofNullable(clazz.cast(this.contentRedactionTypeAsString()));
            }
            case "PiiEntityTypes": {
                return Optional.ofNullable(clazz.cast(this.piiEntityTypes()));
            }
            case "FilterPartialResults": {
                return Optional.ofNullable(clazz.cast(this.filterPartialResults()));
            }
            case "PostCallAnalyticsSettings": {
                return Optional.ofNullable(clazz.cast(this.postCallAnalyticsSettings()));
            }
            case "CallAnalyticsStreamCategories": {
                return Optional.ofNullable(clazz.cast(this.callAnalyticsStreamCategories()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("VocabularyName", VOCABULARY_NAME_FIELD);
        map.put("VocabularyFilterName", VOCABULARY_FILTER_NAME_FIELD);
        map.put("VocabularyFilterMethod", VOCABULARY_FILTER_METHOD_FIELD);
        map.put("LanguageModelName", LANGUAGE_MODEL_NAME_FIELD);
        map.put("EnablePartialResultsStabilization", ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD);
        map.put("PartialResultsStability", PARTIAL_RESULTS_STABILITY_FIELD);
        map.put("ContentIdentificationType", CONTENT_IDENTIFICATION_TYPE_FIELD);
        map.put("ContentRedactionType", CONTENT_REDACTION_TYPE_FIELD);
        map.put("PiiEntityTypes", PII_ENTITY_TYPES_FIELD);
        map.put("FilterPartialResults", FILTER_PARTIAL_RESULTS_FIELD);
        map.put("PostCallAnalyticsSettings", POST_CALL_ANALYTICS_SETTINGS_FIELD);
        map.put("CallAnalyticsStreamCategories", CALL_ANALYTICS_STREAM_CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmazonTranscribeCallAnalyticsProcessorConfiguration, T> g) {
        return obj -> g.apply((AmazonTranscribeCallAnalyticsProcessorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String languageCode;
        private String vocabularyName;
        private String vocabularyFilterName;
        private String vocabularyFilterMethod;
        private String languageModelName;
        private Boolean enablePartialResultsStabilization;
        private String partialResultsStability;
        private String contentIdentificationType;
        private String contentRedactionType;
        private String piiEntityTypes;
        private Boolean filterPartialResults;
        private PostCallAnalyticsSettings postCallAnalyticsSettings;
        private List<String> callAnalyticsStreamCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonTranscribeCallAnalyticsProcessorConfiguration model) {
            this.languageCode(model.languageCode);
            this.vocabularyName(model.vocabularyName);
            this.vocabularyFilterName(model.vocabularyFilterName);
            this.vocabularyFilterMethod(model.vocabularyFilterMethod);
            this.languageModelName(model.languageModelName);
            this.enablePartialResultsStabilization(model.enablePartialResultsStabilization);
            this.partialResultsStability(model.partialResultsStability);
            this.contentIdentificationType(model.contentIdentificationType);
            this.contentRedactionType(model.contentRedactionType);
            this.piiEntityTypes(model.piiEntityTypes);
            this.filterPartialResults(model.filterPartialResults);
            this.postCallAnalyticsSettings(model.postCallAnalyticsSettings);
            this.callAnalyticsStreamCategories(model.callAnalyticsStreamCategories);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(CallAnalyticsLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getVocabularyFilterName() {
            return this.vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return this.vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final String getLanguageModelName() {
            return this.languageModelName;
        }

        public final void setLanguageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
        }

        @Override
        public final Builder languageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
            return this;
        }

        public final Boolean getEnablePartialResultsStabilization() {
            return this.enablePartialResultsStabilization;
        }

        public final void setEnablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
        }

        @Override
        public final Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
            return this;
        }

        public final String getPartialResultsStability() {
            return this.partialResultsStability;
        }

        public final void setPartialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
        }

        @Override
        public final Builder partialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
            return this;
        }

        @Override
        public final Builder partialResultsStability(PartialResultsStability partialResultsStability) {
            this.partialResultsStability(partialResultsStability == null ? null : partialResultsStability.toString());
            return this;
        }

        public final String getContentIdentificationType() {
            return this.contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        public final Builder contentIdentificationType(ContentType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        public final String getContentRedactionType() {
            return this.contentRedactionType;
        }

        public final void setContentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
        }

        @Override
        public final Builder contentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
            return this;
        }

        @Override
        public final Builder contentRedactionType(ContentType contentRedactionType) {
            this.contentRedactionType(contentRedactionType == null ? null : contentRedactionType.toString());
            return this;
        }

        public final String getPiiEntityTypes() {
            return this.piiEntityTypes;
        }

        public final void setPiiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
        }

        @Override
        public final Builder piiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
            return this;
        }

        public final Boolean getFilterPartialResults() {
            return this.filterPartialResults;
        }

        public final void setFilterPartialResults(Boolean filterPartialResults) {
            this.filterPartialResults = filterPartialResults;
        }

        @Override
        public final Builder filterPartialResults(Boolean filterPartialResults) {
            this.filterPartialResults = filterPartialResults;
            return this;
        }

        public final PostCallAnalyticsSettings.Builder getPostCallAnalyticsSettings() {
            return this.postCallAnalyticsSettings != null ? this.postCallAnalyticsSettings.toBuilder() : null;
        }

        public final void setPostCallAnalyticsSettings(PostCallAnalyticsSettings.BuilderImpl postCallAnalyticsSettings) {
            this.postCallAnalyticsSettings = postCallAnalyticsSettings != null ? postCallAnalyticsSettings.build() : null;
        }

        @Override
        public final Builder postCallAnalyticsSettings(PostCallAnalyticsSettings postCallAnalyticsSettings) {
            this.postCallAnalyticsSettings = postCallAnalyticsSettings;
            return this;
        }

        public final Collection<String> getCallAnalyticsStreamCategories() {
            if (this.callAnalyticsStreamCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.callAnalyticsStreamCategories;
        }

        public final void setCallAnalyticsStreamCategories(Collection<String> callAnalyticsStreamCategories) {
            this.callAnalyticsStreamCategories = CategoryNameListCopier.copy(callAnalyticsStreamCategories);
        }

        @Override
        public final Builder callAnalyticsStreamCategories(Collection<String> callAnalyticsStreamCategories) {
            this.callAnalyticsStreamCategories = CategoryNameListCopier.copy(callAnalyticsStreamCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callAnalyticsStreamCategories(String ... callAnalyticsStreamCategories) {
            this.callAnalyticsStreamCategories(Arrays.asList(callAnalyticsStreamCategories));
            return this;
        }

        public AmazonTranscribeCallAnalyticsProcessorConfiguration build() {
            return new AmazonTranscribeCallAnalyticsProcessorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmazonTranscribeCallAnalyticsProcessorConfiguration> {
        public Builder languageCode(String var1);

        public Builder languageCode(CallAnalyticsLanguageCode var1);

        public Builder vocabularyName(String var1);

        public Builder vocabularyFilterName(String var1);

        public Builder vocabularyFilterMethod(String var1);

        public Builder vocabularyFilterMethod(VocabularyFilterMethod var1);

        public Builder languageModelName(String var1);

        public Builder enablePartialResultsStabilization(Boolean var1);

        public Builder partialResultsStability(String var1);

        public Builder partialResultsStability(PartialResultsStability var1);

        public Builder contentIdentificationType(String var1);

        public Builder contentIdentificationType(ContentType var1);

        public Builder contentRedactionType(String var1);

        public Builder contentRedactionType(ContentType var1);

        public Builder piiEntityTypes(String var1);

        public Builder filterPartialResults(Boolean var1);

        public Builder postCallAnalyticsSettings(PostCallAnalyticsSettings var1);

        default public Builder postCallAnalyticsSettings(Consumer<PostCallAnalyticsSettings.Builder> postCallAnalyticsSettings) {
            return this.postCallAnalyticsSettings((PostCallAnalyticsSettings)((PostCallAnalyticsSettings.Builder)PostCallAnalyticsSettings.builder().applyMutation(postCallAnalyticsSettings)).build());
        }

        public Builder callAnalyticsStreamCategories(Collection<String> var1);

        public Builder callAnalyticsStreamCategories(String ... var1);
    }
}

