/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.KeywordMatchWordListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeywordMatchConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeywordMatchConfiguration> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(KeywordMatchConfiguration.getter(KeywordMatchConfiguration::ruleName)).setter(KeywordMatchConfiguration.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<List<String>> KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Keywords").getter(KeywordMatchConfiguration.getter(KeywordMatchConfiguration::keywords)).setter(KeywordMatchConfiguration.setter(Builder::keywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> NEGATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Negate").getter(KeywordMatchConfiguration.getter(KeywordMatchConfiguration::negate)).setter(KeywordMatchConfiguration.setter(Builder::negate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Negate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, KEYWORDS_FIELD, NEGATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KeywordMatchConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ruleName;
    private final List<String> keywords;
    private final Boolean negate;

    private KeywordMatchConfiguration(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.keywords = builder.keywords;
        this.negate = builder.negate;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final boolean hasKeywords() {
        return this.keywords != null && !(this.keywords instanceof SdkAutoConstructList);
    }

    public final List<String> keywords() {
        return this.keywords;
    }

    public final Boolean negate() {
        return this.negate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeywords() ? this.keywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.negate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeywordMatchConfiguration)) {
            return false;
        }
        KeywordMatchConfiguration other = (KeywordMatchConfiguration)obj;
        return Objects.equals(this.ruleName(), other.ruleName()) && this.hasKeywords() == other.hasKeywords() && Objects.equals(this.keywords(), other.keywords()) && Objects.equals(this.negate(), other.negate());
    }

    public final String toString() {
        return ToString.builder((String)"KeywordMatchConfiguration").add("RuleName", (Object)this.ruleName()).add("Keywords", this.hasKeywords() ? this.keywords() : null).add("Negate", (Object)this.negate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "Keywords": {
                return Optional.ofNullable(clazz.cast(this.keywords()));
            }
            case "Negate": {
                return Optional.ofNullable(clazz.cast(this.negate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("Keywords", KEYWORDS_FIELD);
        map.put("Negate", NEGATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeywordMatchConfiguration, T> g) {
        return obj -> g.apply((KeywordMatchConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleName;
        private List<String> keywords = DefaultSdkAutoConstructList.getInstance();
        private Boolean negate;

        private BuilderImpl() {
        }

        private BuilderImpl(KeywordMatchConfiguration model) {
            this.ruleName(model.ruleName);
            this.keywords(model.keywords);
            this.negate(model.negate);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final Collection<String> getKeywords() {
            if (this.keywords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keywords;
        }

        public final void setKeywords(Collection<String> keywords) {
            this.keywords = KeywordMatchWordListCopier.copy(keywords);
        }

        @Override
        public final Builder keywords(Collection<String> keywords) {
            this.keywords = KeywordMatchWordListCopier.copy(keywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keywords(String ... keywords) {
            this.keywords(Arrays.asList(keywords));
            return this;
        }

        public final Boolean getNegate() {
            return this.negate;
        }

        public final void setNegate(Boolean negate) {
            this.negate = negate;
        }

        @Override
        public final Builder negate(Boolean negate) {
            this.negate = negate;
            return this;
        }

        public KeywordMatchConfiguration build() {
            return new KeywordMatchConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeywordMatchConfiguration> {
        public Builder ruleName(String var1);

        public Builder keywords(Collection<String> var1);

        public Builder keywords(String ... var1);

        public Builder negate(Boolean var1);
    }
}

