/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMediaPipelinesResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaCapturePipelineSummary;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaCapturePipelineSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMediaCapturePipelinesResponse
extends ChimeSdkMediaPipelinesResponse
implements ToCopyableBuilder<Builder, ListMediaCapturePipelinesResponse> {
    private static final SdkField<List<MediaCapturePipelineSummary>> MEDIA_CAPTURE_PIPELINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaCapturePipelines").getter(ListMediaCapturePipelinesResponse.getter(ListMediaCapturePipelinesResponse::mediaCapturePipelines)).setter(ListMediaCapturePipelinesResponse.setter(Builder::mediaCapturePipelines)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaCapturePipelines").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaCapturePipelineSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMediaCapturePipelinesResponse.getter(ListMediaCapturePipelinesResponse::nextToken)).setter(ListMediaCapturePipelinesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_CAPTURE_PIPELINES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMediaCapturePipelinesResponse.memberNameToFieldInitializer();
    private final List<MediaCapturePipelineSummary> mediaCapturePipelines;
    private final String nextToken;

    private ListMediaCapturePipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.mediaCapturePipelines = builder.mediaCapturePipelines;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMediaCapturePipelines() {
        return this.mediaCapturePipelines != null && !(this.mediaCapturePipelines instanceof SdkAutoConstructList);
    }

    public final List<MediaCapturePipelineSummary> mediaCapturePipelines() {
        return this.mediaCapturePipelines;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaCapturePipelines() ? this.mediaCapturePipelines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMediaCapturePipelinesResponse)) {
            return false;
        }
        ListMediaCapturePipelinesResponse other = (ListMediaCapturePipelinesResponse)((Object)obj);
        return this.hasMediaCapturePipelines() == other.hasMediaCapturePipelines() && Objects.equals(this.mediaCapturePipelines(), other.mediaCapturePipelines()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMediaCapturePipelinesResponse").add("MediaCapturePipelines", this.hasMediaCapturePipelines() ? this.mediaCapturePipelines() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaCapturePipelines": {
                return Optional.ofNullable(clazz.cast(this.mediaCapturePipelines()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MediaCapturePipelines", MEDIA_CAPTURE_PIPELINES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMediaCapturePipelinesResponse, T> g) {
        return obj -> g.apply((ListMediaCapturePipelinesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMediaPipelinesResponse.BuilderImpl
    implements Builder {
        private List<MediaCapturePipelineSummary> mediaCapturePipelines = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMediaCapturePipelinesResponse model) {
            super(model);
            this.mediaCapturePipelines(model.mediaCapturePipelines);
            this.nextToken(model.nextToken);
        }

        public final List<MediaCapturePipelineSummary.Builder> getMediaCapturePipelines() {
            List<MediaCapturePipelineSummary.Builder> result = MediaCapturePipelineSummaryListCopier.copyToBuilder(this.mediaCapturePipelines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaCapturePipelines(Collection<MediaCapturePipelineSummary.BuilderImpl> mediaCapturePipelines) {
            this.mediaCapturePipelines = MediaCapturePipelineSummaryListCopier.copyFromBuilder(mediaCapturePipelines);
        }

        @Override
        public final Builder mediaCapturePipelines(Collection<MediaCapturePipelineSummary> mediaCapturePipelines) {
            this.mediaCapturePipelines = MediaCapturePipelineSummaryListCopier.copy(mediaCapturePipelines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaCapturePipelines(MediaCapturePipelineSummary ... mediaCapturePipelines) {
            this.mediaCapturePipelines(Arrays.asList(mediaCapturePipelines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaCapturePipelines(Consumer<MediaCapturePipelineSummary.Builder> ... mediaCapturePipelines) {
            this.mediaCapturePipelines(Stream.of(mediaCapturePipelines).map(c -> (MediaCapturePipelineSummary)((MediaCapturePipelineSummary.Builder)MediaCapturePipelineSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMediaCapturePipelinesResponse build() {
            return new ListMediaCapturePipelinesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkMediaPipelinesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMediaCapturePipelinesResponse> {
        public Builder mediaCapturePipelines(Collection<MediaCapturePipelineSummary> var1);

        public Builder mediaCapturePipelines(MediaCapturePipelineSummary ... var1);

        public Builder mediaCapturePipelines(Consumer<MediaCapturePipelineSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

