/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMeetingConcatenationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaCapturePipelineSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaCapturePipelineSourceConfiguration> {
    private static final SdkField<String> MEDIA_PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaPipelineArn").getter(MediaCapturePipelineSourceConfiguration.getter(MediaCapturePipelineSourceConfiguration::mediaPipelineArn)).setter(MediaCapturePipelineSourceConfiguration.setter(Builder::mediaPipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelineArn").build()}).build();
    private static final SdkField<ChimeSdkMeetingConcatenationConfiguration> CHIME_SDK_MEETING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChimeSdkMeetingConfiguration").getter(MediaCapturePipelineSourceConfiguration.getter(MediaCapturePipelineSourceConfiguration::chimeSdkMeetingConfiguration)).setter(MediaCapturePipelineSourceConfiguration.setter(Builder::chimeSdkMeetingConfiguration)).constructor(ChimeSdkMeetingConcatenationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChimeSdkMeetingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_PIPELINE_ARN_FIELD, CHIME_SDK_MEETING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MediaPipelineArn", MEDIA_PIPELINE_ARN_FIELD);
            this.put("ChimeSdkMeetingConfiguration", CHIME_SDK_MEETING_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String mediaPipelineArn;
    private final ChimeSdkMeetingConcatenationConfiguration chimeSdkMeetingConfiguration;

    private MediaCapturePipelineSourceConfiguration(BuilderImpl builder) {
        this.mediaPipelineArn = builder.mediaPipelineArn;
        this.chimeSdkMeetingConfiguration = builder.chimeSdkMeetingConfiguration;
    }

    public final String mediaPipelineArn() {
        return this.mediaPipelineArn;
    }

    public final ChimeSdkMeetingConcatenationConfiguration chimeSdkMeetingConfiguration() {
        return this.chimeSdkMeetingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.chimeSdkMeetingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaCapturePipelineSourceConfiguration)) {
            return false;
        }
        MediaCapturePipelineSourceConfiguration other = (MediaCapturePipelineSourceConfiguration)obj;
        return Objects.equals(this.mediaPipelineArn(), other.mediaPipelineArn()) && Objects.equals(this.chimeSdkMeetingConfiguration(), other.chimeSdkMeetingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"MediaCapturePipelineSourceConfiguration").add("MediaPipelineArn", (Object)(this.mediaPipelineArn() == null ? null : "*** Sensitive Data Redacted ***")).add("ChimeSdkMeetingConfiguration", (Object)this.chimeSdkMeetingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaPipelineArn": {
                return Optional.ofNullable(clazz.cast(this.mediaPipelineArn()));
            }
            case "ChimeSdkMeetingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.chimeSdkMeetingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MediaCapturePipelineSourceConfiguration, T> g) {
        return obj -> g.apply((MediaCapturePipelineSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mediaPipelineArn;
        private ChimeSdkMeetingConcatenationConfiguration chimeSdkMeetingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaCapturePipelineSourceConfiguration model) {
            this.mediaPipelineArn(model.mediaPipelineArn);
            this.chimeSdkMeetingConfiguration(model.chimeSdkMeetingConfiguration);
        }

        public final String getMediaPipelineArn() {
            return this.mediaPipelineArn;
        }

        public final void setMediaPipelineArn(String mediaPipelineArn) {
            this.mediaPipelineArn = mediaPipelineArn;
        }

        @Override
        public final Builder mediaPipelineArn(String mediaPipelineArn) {
            this.mediaPipelineArn = mediaPipelineArn;
            return this;
        }

        public final ChimeSdkMeetingConcatenationConfiguration.Builder getChimeSdkMeetingConfiguration() {
            return this.chimeSdkMeetingConfiguration != null ? this.chimeSdkMeetingConfiguration.toBuilder() : null;
        }

        public final void setChimeSdkMeetingConfiguration(ChimeSdkMeetingConcatenationConfiguration.BuilderImpl chimeSdkMeetingConfiguration) {
            this.chimeSdkMeetingConfiguration = chimeSdkMeetingConfiguration != null ? chimeSdkMeetingConfiguration.build() : null;
        }

        @Override
        public final Builder chimeSdkMeetingConfiguration(ChimeSdkMeetingConcatenationConfiguration chimeSdkMeetingConfiguration) {
            this.chimeSdkMeetingConfiguration = chimeSdkMeetingConfiguration;
            return this;
        }

        public MediaCapturePipelineSourceConfiguration build() {
            return new MediaCapturePipelineSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaCapturePipelineSourceConfiguration> {
        public Builder mediaPipelineArn(String var1);

        public Builder chimeSdkMeetingConfiguration(ChimeSdkMeetingConcatenationConfiguration var1);

        default public Builder chimeSdkMeetingConfiguration(Consumer<ChimeSdkMeetingConcatenationConfiguration.Builder> chimeSdkMeetingConfiguration) {
            return this.chimeSdkMeetingConfiguration((ChimeSdkMeetingConcatenationConfiguration)((ChimeSdkMeetingConcatenationConfiguration.Builder)ChimeSdkMeetingConcatenationConfiguration.builder().applyMutation(chimeSdkMeetingConfiguration)).build());
        }
    }
}

