/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmediapipelines.ChimeSdkMediaPipelinesAsyncClient;
import software.amazon.awssdk.services.chimesdkmediapipelines.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse;

public class ListMediaInsightsPipelineConfigurationsPublisher
implements SdkPublisher<ListMediaInsightsPipelineConfigurationsResponse> {
    private final ChimeSdkMediaPipelinesAsyncClient client;
    private final ListMediaInsightsPipelineConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMediaInsightsPipelineConfigurationsPublisher(ChimeSdkMediaPipelinesAsyncClient client, ListMediaInsightsPipelineConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMediaInsightsPipelineConfigurationsPublisher(ChimeSdkMediaPipelinesAsyncClient client, ListMediaInsightsPipelineConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMediaInsightsPipelineConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMediaInsightsPipelineConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMediaInsightsPipelineConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListMediaInsightsPipelineConfigurationsResponse> {
        private ListMediaInsightsPipelineConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListMediaInsightsPipelineConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMediaInsightsPipelineConfigurationsResponse> nextPage(ListMediaInsightsPipelineConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListMediaInsightsPipelineConfigurationsPublisher.this.client.listMediaInsightsPipelineConfigurations(ListMediaInsightsPipelineConfigurationsPublisher.this.firstRequest);
            }
            return ListMediaInsightsPipelineConfigurationsPublisher.this.client.listMediaInsightsPipelineConfigurations((ListMediaInsightsPipelineConfigurationsRequest)((Object)ListMediaInsightsPipelineConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

