/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmediapipelines.ChimeSdkMediaPipelinesAsyncClient;
import software.amazon.awssdk.services.chimesdkmediapipelines.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsResponse;

public class ListMediaPipelineKinesisVideoStreamPoolsPublisher
implements SdkPublisher<ListMediaPipelineKinesisVideoStreamPoolsResponse> {
    private final ChimeSdkMediaPipelinesAsyncClient client;
    private final ListMediaPipelineKinesisVideoStreamPoolsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMediaPipelineKinesisVideoStreamPoolsPublisher(ChimeSdkMediaPipelinesAsyncClient client, ListMediaPipelineKinesisVideoStreamPoolsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMediaPipelineKinesisVideoStreamPoolsPublisher(ChimeSdkMediaPipelinesAsyncClient client, ListMediaPipelineKinesisVideoStreamPoolsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMediaPipelineKinesisVideoStreamPoolsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMediaPipelineKinesisVideoStreamPoolsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMediaPipelineKinesisVideoStreamPoolsResponseFetcher
    implements AsyncPageFetcher<ListMediaPipelineKinesisVideoStreamPoolsResponse> {
        private ListMediaPipelineKinesisVideoStreamPoolsResponseFetcher() {
        }

        public boolean hasNextPage(ListMediaPipelineKinesisVideoStreamPoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMediaPipelineKinesisVideoStreamPoolsResponse> nextPage(ListMediaPipelineKinesisVideoStreamPoolsResponse previousPage) {
            if (previousPage == null) {
                return ListMediaPipelineKinesisVideoStreamPoolsPublisher.this.client.listMediaPipelineKinesisVideoStreamPools(ListMediaPipelineKinesisVideoStreamPoolsPublisher.this.firstRequest);
            }
            return ListMediaPipelineKinesisVideoStreamPoolsPublisher.this.client.listMediaPipelineKinesisVideoStreamPools((ListMediaPipelineKinesisVideoStreamPoolsRequest)((Object)ListMediaPipelineKinesisVideoStreamPoolsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

