/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMediaPipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSink;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSinkListCopier;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSource;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ConcatenationSourceListCopier;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMediaConcatenationPipelineRequest
extends ChimeSdkMediaPipelinesRequest
implements ToCopyableBuilder<Builder, CreateMediaConcatenationPipelineRequest> {
    private static final SdkField<List<ConcatenationSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(CreateMediaConcatenationPipelineRequest.getter(CreateMediaConcatenationPipelineRequest::sources)).setter(CreateMediaConcatenationPipelineRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConcatenationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ConcatenationSink>> SINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sinks").getter(CreateMediaConcatenationPipelineRequest.getter(CreateMediaConcatenationPipelineRequest::sinks)).setter(CreateMediaConcatenationPipelineRequest.setter(Builder::sinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConcatenationSink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateMediaConcatenationPipelineRequest.getter(CreateMediaConcatenationPipelineRequest::clientRequestToken)).setter(CreateMediaConcatenationPipelineRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateMediaConcatenationPipelineRequest.getter(CreateMediaConcatenationPipelineRequest::tags)).setter(CreateMediaConcatenationPipelineRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCES_FIELD, SINKS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));
    private final List<ConcatenationSource> sources;
    private final List<ConcatenationSink> sinks;
    private final String clientRequestToken;
    private final List<Tag> tags;

    private CreateMediaConcatenationPipelineRequest(BuilderImpl builder) {
        super(builder);
        this.sources = builder.sources;
        this.sinks = builder.sinks;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<ConcatenationSource> sources() {
        return this.sources;
    }

    public final boolean hasSinks() {
        return this.sinks != null && !(this.sinks instanceof SdkAutoConstructList);
    }

    public final List<ConcatenationSink> sinks() {
        return this.sinks;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSinks() ? this.sinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaConcatenationPipelineRequest)) {
            return false;
        }
        CreateMediaConcatenationPipelineRequest other = (CreateMediaConcatenationPipelineRequest)((Object)obj);
        return this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && this.hasSinks() == other.hasSinks() && Objects.equals(this.sinks(), other.sinks()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMediaConcatenationPipelineRequest").add("Sources", this.hasSources() ? this.sources() : null).add("Sinks", this.hasSinks() ? this.sinks() : null).add("ClientRequestToken", (Object)(this.clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "Sinks": {
                return Optional.ofNullable(clazz.cast(this.sinks()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaConcatenationPipelineRequest, T> g) {
        return obj -> g.apply((CreateMediaConcatenationPipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMediaPipelinesRequest.BuilderImpl
    implements Builder {
        private List<ConcatenationSource> sources = DefaultSdkAutoConstructList.getInstance();
        private List<ConcatenationSink> sinks = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaConcatenationPipelineRequest model) {
            super(model);
            this.sources(model.sources);
            this.sinks(model.sinks);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final List<ConcatenationSource.Builder> getSources() {
            List<ConcatenationSource.Builder> result = ConcatenationSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<ConcatenationSource.BuilderImpl> sources) {
            this.sources = ConcatenationSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<ConcatenationSource> sources) {
            this.sources = ConcatenationSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(ConcatenationSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<ConcatenationSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (ConcatenationSource)((ConcatenationSource.Builder)ConcatenationSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ConcatenationSink.Builder> getSinks() {
            List<ConcatenationSink.Builder> result = ConcatenationSinkListCopier.copyToBuilder(this.sinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSinks(Collection<ConcatenationSink.BuilderImpl> sinks) {
            this.sinks = ConcatenationSinkListCopier.copyFromBuilder(sinks);
        }

        @Override
        public final Builder sinks(Collection<ConcatenationSink> sinks) {
            this.sinks = ConcatenationSinkListCopier.copy(sinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(ConcatenationSink ... sinks) {
            this.sinks(Arrays.asList(sinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(Consumer<ConcatenationSink.Builder> ... sinks) {
            this.sinks(Stream.of(sinks).map(c -> (ConcatenationSink)((ConcatenationSink.Builder)ConcatenationSink.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMediaConcatenationPipelineRequest build() {
            return new CreateMediaConcatenationPipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkMediaPipelinesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMediaConcatenationPipelineRequest> {
        public Builder sources(Collection<ConcatenationSource> var1);

        public Builder sources(ConcatenationSource ... var1);

        public Builder sources(Consumer<ConcatenationSource.Builder> ... var1);

        public Builder sinks(Collection<ConcatenationSink> var1);

        public Builder sinks(ConcatenationSink ... var1);

        public Builder sinks(Consumer<ConcatenationSink.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

