/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMediaPipelinesResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMediaInsightsPipelineConfigurationsResponse
extends ChimeSdkMediaPipelinesResponse
implements ToCopyableBuilder<Builder, ListMediaInsightsPipelineConfigurationsResponse> {
    private static final SdkField<List<MediaInsightsPipelineConfigurationSummary>> MEDIA_INSIGHTS_PIPELINE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaInsightsPipelineConfigurations").getter(ListMediaInsightsPipelineConfigurationsResponse.getter(ListMediaInsightsPipelineConfigurationsResponse::mediaInsightsPipelineConfigurations)).setter(ListMediaInsightsPipelineConfigurationsResponse.setter(Builder::mediaInsightsPipelineConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaInsightsPipelineConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaInsightsPipelineConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMediaInsightsPipelineConfigurationsResponse.getter(ListMediaInsightsPipelineConfigurationsResponse::nextToken)).setter(ListMediaInsightsPipelineConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_INSIGHTS_PIPELINE_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<MediaInsightsPipelineConfigurationSummary> mediaInsightsPipelineConfigurations;
    private final String nextToken;

    private ListMediaInsightsPipelineConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.mediaInsightsPipelineConfigurations = builder.mediaInsightsPipelineConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMediaInsightsPipelineConfigurations() {
        return this.mediaInsightsPipelineConfigurations != null && !(this.mediaInsightsPipelineConfigurations instanceof SdkAutoConstructList);
    }

    public final List<MediaInsightsPipelineConfigurationSummary> mediaInsightsPipelineConfigurations() {
        return this.mediaInsightsPipelineConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaInsightsPipelineConfigurations() ? this.mediaInsightsPipelineConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMediaInsightsPipelineConfigurationsResponse)) {
            return false;
        }
        ListMediaInsightsPipelineConfigurationsResponse other = (ListMediaInsightsPipelineConfigurationsResponse)((Object)obj);
        return this.hasMediaInsightsPipelineConfigurations() == other.hasMediaInsightsPipelineConfigurations() && Objects.equals(this.mediaInsightsPipelineConfigurations(), other.mediaInsightsPipelineConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMediaInsightsPipelineConfigurationsResponse").add("MediaInsightsPipelineConfigurations", this.hasMediaInsightsPipelineConfigurations() ? this.mediaInsightsPipelineConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaInsightsPipelineConfigurations": {
                return Optional.ofNullable(clazz.cast(this.mediaInsightsPipelineConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMediaInsightsPipelineConfigurationsResponse, T> g) {
        return obj -> g.apply((ListMediaInsightsPipelineConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMediaPipelinesResponse.BuilderImpl
    implements Builder {
        private List<MediaInsightsPipelineConfigurationSummary> mediaInsightsPipelineConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMediaInsightsPipelineConfigurationsResponse model) {
            super(model);
            this.mediaInsightsPipelineConfigurations(model.mediaInsightsPipelineConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<MediaInsightsPipelineConfigurationSummary.Builder> getMediaInsightsPipelineConfigurations() {
            List<MediaInsightsPipelineConfigurationSummary.Builder> result = MediaInsightsPipelineConfigurationSummaryListCopier.copyToBuilder(this.mediaInsightsPipelineConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaInsightsPipelineConfigurations(Collection<MediaInsightsPipelineConfigurationSummary.BuilderImpl> mediaInsightsPipelineConfigurations) {
            this.mediaInsightsPipelineConfigurations = MediaInsightsPipelineConfigurationSummaryListCopier.copyFromBuilder(mediaInsightsPipelineConfigurations);
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurations(Collection<MediaInsightsPipelineConfigurationSummary> mediaInsightsPipelineConfigurations) {
            this.mediaInsightsPipelineConfigurations = MediaInsightsPipelineConfigurationSummaryListCopier.copy(mediaInsightsPipelineConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaInsightsPipelineConfigurations(MediaInsightsPipelineConfigurationSummary ... mediaInsightsPipelineConfigurations) {
            this.mediaInsightsPipelineConfigurations(Arrays.asList(mediaInsightsPipelineConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaInsightsPipelineConfigurations(Consumer<MediaInsightsPipelineConfigurationSummary.Builder> ... mediaInsightsPipelineConfigurations) {
            this.mediaInsightsPipelineConfigurations(Stream.of(mediaInsightsPipelineConfigurations).map(c -> (MediaInsightsPipelineConfigurationSummary)((MediaInsightsPipelineConfigurationSummary.Builder)MediaInsightsPipelineConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMediaInsightsPipelineConfigurationsResponse build() {
            return new ListMediaInsightsPipelineConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkMediaPipelinesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMediaInsightsPipelineConfigurationsResponse> {
        public Builder mediaInsightsPipelineConfigurations(Collection<MediaInsightsPipelineConfigurationSummary> var1);

        public Builder mediaInsightsPipelineConfigurations(MediaInsightsPipelineConfigurationSummary ... var1);

        public Builder mediaInsightsPipelineConfigurations(Consumer<MediaInsightsPipelineConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

