/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CallAnalyticsLanguageCode;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ContentType;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.PartialResultsStability;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.VocabularyFilterMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmazonTranscribeProcessorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmazonTranscribeProcessorConfiguration> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(AmazonTranscribeProcessorConfiguration.getter(AmazonTranscribeProcessorConfiguration::languageCodeAsString)).setter(AmazonTranscribeProcessorConfiguration.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(AmazonTranscribeProcessorConfiguration.getter(AmazonTranscribeProcessorConfiguration::vocabularyName)).setter(AmazonTranscribeProcessorConfiguration.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterName").getter(AmazonTranscribeProcessorConfiguration.getter(AmazonTranscribeProcessorConfiguration::vocabularyFilterName)).setter(AmazonTranscribeProcessorConfiguration.setter(Builder::vocabularyFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterMethod").getter(AmazonTranscribeProcessorConfiguration.getter(AmazonTranscribeProcessorConfiguration::vocabularyFilterMethodAsString)).setter(AmazonTranscribeProcessorConfiguration.setter(Builder::vocabularyFilterMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build()}).build();
    private static final SdkField<Boolean> SHOW_SPEAKER_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ShowSpeakerLabel").getter(AmazonTranscribeProcessorConfiguration.getter(AmazonTranscribeProcessorConfiguration::showSpeakerLabel)).setter(AmazonTranscribeProcessorConfiguration.setter(Builder::showSpeakerLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowSpeakerLabel").build()}).build();
    private static final SdkField<Boolean> ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePartialResultsStabilization").getter(AmazonTranscribeProcessorConfiguration.getter(AmazonTranscribeProcessorConfiguration::enablePartialResultsStabilization)).setter(AmazonTranscribeProcessorConfiguration.setter(Builder::enablePartialResultsStabilization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePartialResultsStabilization").build()}).build();
    private static final SdkField<String> PARTIAL_RESULTS_STABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartialResultsStability").getter(AmazonTranscribeProcessorConfiguration.getter(AmazonTranscribeProcessorConfiguration::partialResultsStabilityAsString)).setter(AmazonTranscribeProcessorConfiguration.setter(Builder::partialResultsStability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartialResultsStability").build()}).build();
    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentIdentificationType").getter(AmazonTranscribeProcessorConfiguration.getter(AmazonTranscribeProcessorConfiguration::contentIdentificationTypeAsString)).setter(AmazonTranscribeProcessorConfiguration.setter(Builder::contentIdentificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentIdentificationType").build()}).build();
    private static final SdkField<String> CONTENT_REDACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentRedactionType").getter(AmazonTranscribeProcessorConfiguration.getter(AmazonTranscribeProcessorConfiguration::contentRedactionTypeAsString)).setter(AmazonTranscribeProcessorConfiguration.setter(Builder::contentRedactionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedactionType").build()}).build();
    private static final SdkField<String> PII_ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PiiEntityTypes").getter(AmazonTranscribeProcessorConfiguration.getter(AmazonTranscribeProcessorConfiguration::piiEntityTypes)).setter(AmazonTranscribeProcessorConfiguration.setter(Builder::piiEntityTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PiiEntityTypes").build()}).build();
    private static final SdkField<String> LANGUAGE_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageModelName").getter(AmazonTranscribeProcessorConfiguration.getter(AmazonTranscribeProcessorConfiguration::languageModelName)).setter(AmazonTranscribeProcessorConfiguration.setter(Builder::languageModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageModelName").build()}).build();
    private static final SdkField<Boolean> FILTER_PARTIAL_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FilterPartialResults").getter(AmazonTranscribeProcessorConfiguration.getter(AmazonTranscribeProcessorConfiguration::filterPartialResults)).setter(AmazonTranscribeProcessorConfiguration.setter(Builder::filterPartialResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterPartialResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD, VOCABULARY_NAME_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, SHOW_SPEAKER_LABEL_FIELD, ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD, PARTIAL_RESULTS_STABILITY_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD, CONTENT_REDACTION_TYPE_FIELD, PII_ENTITY_TYPES_FIELD, LANGUAGE_MODEL_NAME_FIELD, FILTER_PARTIAL_RESULTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String languageCode;
    private final String vocabularyName;
    private final String vocabularyFilterName;
    private final String vocabularyFilterMethod;
    private final Boolean showSpeakerLabel;
    private final Boolean enablePartialResultsStabilization;
    private final String partialResultsStability;
    private final String contentIdentificationType;
    private final String contentRedactionType;
    private final String piiEntityTypes;
    private final String languageModelName;
    private final Boolean filterPartialResults;

    private AmazonTranscribeProcessorConfiguration(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.vocabularyName = builder.vocabularyName;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.showSpeakerLabel = builder.showSpeakerLabel;
        this.enablePartialResultsStabilization = builder.enablePartialResultsStabilization;
        this.partialResultsStability = builder.partialResultsStability;
        this.contentIdentificationType = builder.contentIdentificationType;
        this.contentRedactionType = builder.contentRedactionType;
        this.piiEntityTypes = builder.piiEntityTypes;
        this.languageModelName = builder.languageModelName;
        this.filterPartialResults = builder.filterPartialResults;
    }

    public final CallAnalyticsLanguageCode languageCode() {
        return CallAnalyticsLanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final String vocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public final VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(this.vocabularyFilterMethod);
    }

    public final String vocabularyFilterMethodAsString() {
        return this.vocabularyFilterMethod;
    }

    public final Boolean showSpeakerLabel() {
        return this.showSpeakerLabel;
    }

    public final Boolean enablePartialResultsStabilization() {
        return this.enablePartialResultsStabilization;
    }

    public final PartialResultsStability partialResultsStability() {
        return PartialResultsStability.fromValue(this.partialResultsStability);
    }

    public final String partialResultsStabilityAsString() {
        return this.partialResultsStability;
    }

    public final ContentType contentIdentificationType() {
        return ContentType.fromValue(this.contentIdentificationType);
    }

    public final String contentIdentificationTypeAsString() {
        return this.contentIdentificationType;
    }

    public final ContentType contentRedactionType() {
        return ContentType.fromValue(this.contentRedactionType);
    }

    public final String contentRedactionTypeAsString() {
        return this.contentRedactionType;
    }

    public final String piiEntityTypes() {
        return this.piiEntityTypes;
    }

    public final String languageModelName() {
        return this.languageModelName;
    }

    public final Boolean filterPartialResults() {
        return this.filterPartialResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.showSpeakerLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePartialResultsStabilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.partialResultsStabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentIdentificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRedactionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.piiEntityTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPartialResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonTranscribeProcessorConfiguration)) {
            return false;
        }
        AmazonTranscribeProcessorConfiguration other = (AmazonTranscribeProcessorConfiguration)obj;
        return Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.vocabularyFilterName(), other.vocabularyFilterName()) && Objects.equals(this.vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString()) && Objects.equals(this.showSpeakerLabel(), other.showSpeakerLabel()) && Objects.equals(this.enablePartialResultsStabilization(), other.enablePartialResultsStabilization()) && Objects.equals(this.partialResultsStabilityAsString(), other.partialResultsStabilityAsString()) && Objects.equals(this.contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString()) && Objects.equals(this.contentRedactionTypeAsString(), other.contentRedactionTypeAsString()) && Objects.equals(this.piiEntityTypes(), other.piiEntityTypes()) && Objects.equals(this.languageModelName(), other.languageModelName()) && Objects.equals(this.filterPartialResults(), other.filterPartialResults());
    }

    public final String toString() {
        return ToString.builder((String)"AmazonTranscribeProcessorConfiguration").add("LanguageCode", (Object)this.languageCodeAsString()).add("VocabularyName", (Object)this.vocabularyName()).add("VocabularyFilterName", (Object)this.vocabularyFilterName()).add("VocabularyFilterMethod", (Object)this.vocabularyFilterMethodAsString()).add("ShowSpeakerLabel", (Object)this.showSpeakerLabel()).add("EnablePartialResultsStabilization", (Object)this.enablePartialResultsStabilization()).add("PartialResultsStability", (Object)this.partialResultsStabilityAsString()).add("ContentIdentificationType", (Object)this.contentIdentificationTypeAsString()).add("ContentRedactionType", (Object)this.contentRedactionTypeAsString()).add("PiiEntityTypes", (Object)this.piiEntityTypes()).add("LanguageModelName", (Object)this.languageModelName()).add("FilterPartialResults", (Object)this.filterPartialResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "VocabularyFilterName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterName()));
            }
            case "VocabularyFilterMethod": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMethodAsString()));
            }
            case "ShowSpeakerLabel": {
                return Optional.ofNullable(clazz.cast(this.showSpeakerLabel()));
            }
            case "EnablePartialResultsStabilization": {
                return Optional.ofNullable(clazz.cast(this.enablePartialResultsStabilization()));
            }
            case "PartialResultsStability": {
                return Optional.ofNullable(clazz.cast(this.partialResultsStabilityAsString()));
            }
            case "ContentIdentificationType": {
                return Optional.ofNullable(clazz.cast(this.contentIdentificationTypeAsString()));
            }
            case "ContentRedactionType": {
                return Optional.ofNullable(clazz.cast(this.contentRedactionTypeAsString()));
            }
            case "PiiEntityTypes": {
                return Optional.ofNullable(clazz.cast(this.piiEntityTypes()));
            }
            case "LanguageModelName": {
                return Optional.ofNullable(clazz.cast(this.languageModelName()));
            }
            case "FilterPartialResults": {
                return Optional.ofNullable(clazz.cast(this.filterPartialResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmazonTranscribeProcessorConfiguration, T> g) {
        return obj -> g.apply((AmazonTranscribeProcessorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String languageCode;
        private String vocabularyName;
        private String vocabularyFilterName;
        private String vocabularyFilterMethod;
        private Boolean showSpeakerLabel;
        private Boolean enablePartialResultsStabilization;
        private String partialResultsStability;
        private String contentIdentificationType;
        private String contentRedactionType;
        private String piiEntityTypes;
        private String languageModelName;
        private Boolean filterPartialResults;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonTranscribeProcessorConfiguration model) {
            this.languageCode(model.languageCode);
            this.vocabularyName(model.vocabularyName);
            this.vocabularyFilterName(model.vocabularyFilterName);
            this.vocabularyFilterMethod(model.vocabularyFilterMethod);
            this.showSpeakerLabel(model.showSpeakerLabel);
            this.enablePartialResultsStabilization(model.enablePartialResultsStabilization);
            this.partialResultsStability(model.partialResultsStability);
            this.contentIdentificationType(model.contentIdentificationType);
            this.contentRedactionType(model.contentRedactionType);
            this.piiEntityTypes(model.piiEntityTypes);
            this.languageModelName(model.languageModelName);
            this.filterPartialResults(model.filterPartialResults);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(CallAnalyticsLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getVocabularyFilterName() {
            return this.vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return this.vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final Boolean getShowSpeakerLabel() {
            return this.showSpeakerLabel;
        }

        public final void setShowSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
        }

        @Override
        public final Builder showSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
            return this;
        }

        public final Boolean getEnablePartialResultsStabilization() {
            return this.enablePartialResultsStabilization;
        }

        public final void setEnablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
        }

        @Override
        public final Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
            return this;
        }

        public final String getPartialResultsStability() {
            return this.partialResultsStability;
        }

        public final void setPartialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
        }

        @Override
        public final Builder partialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
            return this;
        }

        @Override
        public final Builder partialResultsStability(PartialResultsStability partialResultsStability) {
            this.partialResultsStability(partialResultsStability == null ? null : partialResultsStability.toString());
            return this;
        }

        public final String getContentIdentificationType() {
            return this.contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        public final Builder contentIdentificationType(ContentType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        public final String getContentRedactionType() {
            return this.contentRedactionType;
        }

        public final void setContentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
        }

        @Override
        public final Builder contentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
            return this;
        }

        @Override
        public final Builder contentRedactionType(ContentType contentRedactionType) {
            this.contentRedactionType(contentRedactionType == null ? null : contentRedactionType.toString());
            return this;
        }

        public final String getPiiEntityTypes() {
            return this.piiEntityTypes;
        }

        public final void setPiiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
        }

        @Override
        public final Builder piiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
            return this;
        }

        public final String getLanguageModelName() {
            return this.languageModelName;
        }

        public final void setLanguageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
        }

        @Override
        public final Builder languageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
            return this;
        }

        public final Boolean getFilterPartialResults() {
            return this.filterPartialResults;
        }

        public final void setFilterPartialResults(Boolean filterPartialResults) {
            this.filterPartialResults = filterPartialResults;
        }

        @Override
        public final Builder filterPartialResults(Boolean filterPartialResults) {
            this.filterPartialResults = filterPartialResults;
            return this;
        }

        public AmazonTranscribeProcessorConfiguration build() {
            return new AmazonTranscribeProcessorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmazonTranscribeProcessorConfiguration> {
        public Builder languageCode(String var1);

        public Builder languageCode(CallAnalyticsLanguageCode var1);

        public Builder vocabularyName(String var1);

        public Builder vocabularyFilterName(String var1);

        public Builder vocabularyFilterMethod(String var1);

        public Builder vocabularyFilterMethod(VocabularyFilterMethod var1);

        public Builder showSpeakerLabel(Boolean var1);

        public Builder enablePartialResultsStabilization(Boolean var1);

        public Builder partialResultsStability(String var1);

        public Builder partialResultsStability(PartialResultsStability var1);

        public Builder contentIdentificationType(String var1);

        public Builder contentIdentificationType(ContentType var1);

        public Builder contentRedactionType(String var1);

        public Builder contentRedactionType(ContentType var1);

        public Builder piiEntityTypes(String var1);

        public Builder languageModelName(String var1);

        public Builder filterPartialResults(Boolean var1);
    }
}

