/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MediaPipelineStatus {
    INITIALIZING("Initializing"),
    IN_PROGRESS("InProgress"),
    FAILED("Failed"),
    STOPPING("Stopping"),
    STOPPED("Stopped"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MediaPipelineStatus> VALUE_MAP;
    private final String value;

    private MediaPipelineStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaPipelineStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MediaPipelineStatus> knownValues() {
        EnumSet<MediaPipelineStatus> knownValues = EnumSet.allOf(MediaPipelineStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MediaPipelineStatus.class, MediaPipelineStatus::toString);
    }
}

