/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines the interval after which an <code>AppInstanceUser</code> is automatically deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExpirationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ExpirationSettings.Builder, ExpirationSettings> {
    private static final SdkField<Integer> EXPIRATION_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExpirationDays").getter(getter(ExpirationSettings::expirationDays))
            .setter(setter(Builder::expirationDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDays").build()).build();

    private static final SdkField<String> EXPIRATION_CRITERION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpirationCriterion").getter(getter(ExpirationSettings::expirationCriterionAsString))
            .setter(setter(Builder::expirationCriterion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationCriterion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRATION_DAYS_FIELD,
            EXPIRATION_CRITERION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer expirationDays;

    private final String expirationCriterion;

    private ExpirationSettings(BuilderImpl builder) {
        this.expirationDays = builder.expirationDays;
        this.expirationCriterion = builder.expirationCriterion;
    }

    /**
     * <p>
     * The period in days after which an <code>AppInstanceUser</code> will be automatically deleted.
     * </p>
     * 
     * @return The period in days after which an <code>AppInstanceUser</code> will be automatically deleted.
     */
    public final Integer expirationDays() {
        return expirationDays;
    }

    /**
     * <p>
     * Specifies the conditions under which an <code>AppInstanceUser</code> will expire.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expirationCriterion} will return {@link ExpirationCriterion#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #expirationCriterionAsString}.
     * </p>
     * 
     * @return Specifies the conditions under which an <code>AppInstanceUser</code> will expire.
     * @see ExpirationCriterion
     */
    public final ExpirationCriterion expirationCriterion() {
        return ExpirationCriterion.fromValue(expirationCriterion);
    }

    /**
     * <p>
     * Specifies the conditions under which an <code>AppInstanceUser</code> will expire.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expirationCriterion} will return {@link ExpirationCriterion#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #expirationCriterionAsString}.
     * </p>
     * 
     * @return Specifies the conditions under which an <code>AppInstanceUser</code> will expire.
     * @see ExpirationCriterion
     */
    public final String expirationCriterionAsString() {
        return expirationCriterion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expirationDays());
        hashCode = 31 * hashCode + Objects.hashCode(expirationCriterionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpirationSettings)) {
            return false;
        }
        ExpirationSettings other = (ExpirationSettings) obj;
        return Objects.equals(expirationDays(), other.expirationDays())
                && Objects.equals(expirationCriterionAsString(), other.expirationCriterionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExpirationSettings").add("ExpirationDays", expirationDays())
                .add("ExpirationCriterion", expirationCriterionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExpirationDays":
            return Optional.ofNullable(clazz.cast(expirationDays()));
        case "ExpirationCriterion":
            return Optional.ofNullable(clazz.cast(expirationCriterionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExpirationDays", EXPIRATION_DAYS_FIELD);
        map.put("ExpirationCriterion", EXPIRATION_CRITERION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpirationSettings, T> g) {
        return obj -> g.apply((ExpirationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExpirationSettings> {
        /**
         * <p>
         * The period in days after which an <code>AppInstanceUser</code> will be automatically deleted.
         * </p>
         * 
         * @param expirationDays
         *        The period in days after which an <code>AppInstanceUser</code> will be automatically deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDays(Integer expirationDays);

        /**
         * <p>
         * Specifies the conditions under which an <code>AppInstanceUser</code> will expire.
         * </p>
         * 
         * @param expirationCriterion
         *        Specifies the conditions under which an <code>AppInstanceUser</code> will expire.
         * @see ExpirationCriterion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationCriterion
         */
        Builder expirationCriterion(String expirationCriterion);

        /**
         * <p>
         * Specifies the conditions under which an <code>AppInstanceUser</code> will expire.
         * </p>
         * 
         * @param expirationCriterion
         *        Specifies the conditions under which an <code>AppInstanceUser</code> will expire.
         * @see ExpirationCriterion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationCriterion
         */
        Builder expirationCriterion(ExpirationCriterion expirationCriterion);
    }

    static final class BuilderImpl implements Builder {
        private Integer expirationDays;

        private String expirationCriterion;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpirationSettings model) {
            expirationDays(model.expirationDays);
            expirationCriterion(model.expirationCriterion);
        }

        public final Integer getExpirationDays() {
            return expirationDays;
        }

        public final void setExpirationDays(Integer expirationDays) {
            this.expirationDays = expirationDays;
        }

        @Override
        public final Builder expirationDays(Integer expirationDays) {
            this.expirationDays = expirationDays;
            return this;
        }

        public final String getExpirationCriterion() {
            return expirationCriterion;
        }

        public final void setExpirationCriterion(String expirationCriterion) {
            this.expirationCriterion = expirationCriterion;
        }

        @Override
        public final Builder expirationCriterion(String expirationCriterion) {
            this.expirationCriterion = expirationCriterion;
            return this;
        }

        @Override
        public final Builder expirationCriterion(ExpirationCriterion expirationCriterion) {
            this.expirationCriterion(expirationCriterion == null ? null : expirationCriterion.toString());
            return this;
        }

        @Override
        public ExpirationSettings build() {
            return new ExpirationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
