/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.PhoneNumberProductType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePhoneNumberRequestItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdatePhoneNumberRequestItem> {
    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdatePhoneNumberRequestItem.getter(UpdatePhoneNumberRequestItem::phoneNumberId)).setter(UpdatePhoneNumberRequestItem.setter(Builder::phoneNumberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberId").build()}).build();
    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdatePhoneNumberRequestItem.getter(UpdatePhoneNumberRequestItem::productTypeAsString)).setter(UpdatePhoneNumberRequestItem.setter(Builder::productType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ID_FIELD, PRODUCT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String phoneNumberId;
    private final String productType;

    private UpdatePhoneNumberRequestItem(BuilderImpl builder) {
        this.phoneNumberId = builder.phoneNumberId;
        this.productType = builder.productType;
    }

    public String phoneNumberId() {
        return this.phoneNumberId;
    }

    public PhoneNumberProductType productType() {
        return PhoneNumberProductType.fromValue(this.productType);
    }

    public String productTypeAsString() {
        return this.productType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePhoneNumberRequestItem)) {
            return false;
        }
        UpdatePhoneNumberRequestItem other = (UpdatePhoneNumberRequestItem)obj;
        return Objects.equals(this.phoneNumberId(), other.phoneNumberId()) && Objects.equals(this.productTypeAsString(), other.productTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdatePhoneNumberRequestItem").add("PhoneNumberId", (Object)this.phoneNumberId()).add("ProductType", (Object)this.productTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberId": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberId()));
            }
            case "ProductType": {
                return Optional.ofNullable(clazz.cast(this.productTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePhoneNumberRequestItem, T> g) {
        return obj -> g.apply((UpdatePhoneNumberRequestItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String phoneNumberId;
        private String productType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePhoneNumberRequestItem model) {
            this.phoneNumberId(model.phoneNumberId);
            this.productType(model.productType);
        }

        public final String getPhoneNumberId() {
            return this.phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        public final String getProductTypeAsString() {
            return this.productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(PhoneNumberProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        public UpdatePhoneNumberRequestItem build() {
            return new UpdatePhoneNumberRequestItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdatePhoneNumberRequestItem> {
        public Builder phoneNumberId(String var1);

        public Builder productType(String var1);

        public Builder productType(PhoneNumberProductType var1);
    }
}

