/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.License;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserRequestItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateUserRequestItem> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateUserRequestItem.getter(UpdateUserRequestItem::userId)).setter(UpdateUserRequestItem.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateUserRequestItem.getter(UpdateUserRequestItem::licenseTypeAsString)).setter(UpdateUserRequestItem.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, LICENSE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userId;
    private final String licenseType;

    private UpdateUserRequestItem(BuilderImpl builder) {
        this.userId = builder.userId;
        this.licenseType = builder.licenseType;
    }

    public String userId() {
        return this.userId;
    }

    public License licenseType() {
        return License.fromValue(this.licenseType);
    }

    public String licenseTypeAsString() {
        return this.licenseType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequestItem)) {
            return false;
        }
        UpdateUserRequestItem other = (UpdateUserRequestItem)obj;
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateUserRequestItem").add("UserId", (Object)this.userId()).add("LicenseType", (Object)this.licenseTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "LicenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequestItem, T> g) {
        return obj -> g.apply((UpdateUserRequestItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userId;
        private String licenseType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequestItem model) {
            this.userId(model.userId);
            this.licenseType(model.licenseType);
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getLicenseTypeAsString() {
            return this.licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(License licenseType) {
            this.licenseType(licenseType.toString());
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public UpdateUserRequestItem build() {
            return new UpdateUserRequestItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateUserRequestItem> {
        public Builder userId(String var1);

        public Builder licenseType(String var1);

        public Builder licenseType(License var1);
    }
}

