/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VoiceConnector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VoiceConnector> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VoiceConnector.getter(VoiceConnector::voiceConnectorId)).setter(VoiceConnector.setter(Builder::voiceConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VoiceConnector.getter(VoiceConnector::name)).setter(VoiceConnector.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OUTBOUND_HOST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VoiceConnector.getter(VoiceConnector::outboundHostName)).setter(VoiceConnector.setter(Builder::outboundHostName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundHostName").build()}).build();
    private static final SdkField<Boolean> REQUIRE_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(VoiceConnector.getter(VoiceConnector::requireEncryption)).setter(VoiceConnector.setter(Builder::requireEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireEncryption").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(VoiceConnector.getter(VoiceConnector::createdTimestamp)).setter(VoiceConnector.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(VoiceConnector.getter(VoiceConnector::updatedTimestamp)).setter(VoiceConnector.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD, NAME_FIELD, OUTBOUND_HOST_NAME_FIELD, REQUIRE_ENCRYPTION_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String voiceConnectorId;
    private final String name;
    private final String outboundHostName;
    private final Boolean requireEncryption;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;

    private VoiceConnector(BuilderImpl builder) {
        this.voiceConnectorId = builder.voiceConnectorId;
        this.name = builder.name;
        this.outboundHostName = builder.outboundHostName;
        this.requireEncryption = builder.requireEncryption;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    public String voiceConnectorId() {
        return this.voiceConnectorId;
    }

    public String name() {
        return this.name;
    }

    public String outboundHostName() {
        return this.outboundHostName;
    }

    public Boolean requireEncryption() {
        return this.requireEncryption;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.outboundHostName());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceConnector)) {
            return false;
        }
        VoiceConnector other = (VoiceConnector)obj;
        return Objects.equals(this.voiceConnectorId(), other.voiceConnectorId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.outboundHostName(), other.outboundHostName()) && Objects.equals(this.requireEncryption(), other.requireEncryption()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"VoiceConnector").add("VoiceConnectorId", (Object)this.voiceConnectorId()).add("Name", (Object)this.name()).add("OutboundHostName", (Object)this.outboundHostName()).add("RequireEncryption", (Object)this.requireEncryption()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OutboundHostName": {
                return Optional.ofNullable(clazz.cast(this.outboundHostName()));
            }
            case "RequireEncryption": {
                return Optional.ofNullable(clazz.cast(this.requireEncryption()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceConnector, T> g) {
        return obj -> g.apply((VoiceConnector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String voiceConnectorId;
        private String name;
        private String outboundHostName;
        private Boolean requireEncryption;
        private Instant createdTimestamp;
        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceConnector model) {
            this.voiceConnectorId(model.voiceConnectorId);
            this.name(model.name);
            this.outboundHostName(model.outboundHostName);
            this.requireEncryption(model.requireEncryption);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
        }

        public final String getVoiceConnectorId() {
            return this.voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOutboundHostName() {
            return this.outboundHostName;
        }

        @Override
        public final Builder outboundHostName(String outboundHostName) {
            this.outboundHostName = outboundHostName;
            return this;
        }

        public final void setOutboundHostName(String outboundHostName) {
            this.outboundHostName = outboundHostName;
        }

        public final Boolean getRequireEncryption() {
            return this.requireEncryption;
        }

        @Override
        public final Builder requireEncryption(Boolean requireEncryption) {
            this.requireEncryption = requireEncryption;
            return this;
        }

        public final void setRequireEncryption(Boolean requireEncryption) {
            this.requireEncryption = requireEncryption;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        public VoiceConnector build() {
            return new VoiceConnector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VoiceConnector> {
        public Builder voiceConnectorId(String var1);

        public Builder name(String var1);

        public Builder outboundHostName(String var1);

        public Builder requireEncryption(Boolean var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);
    }
}

