/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The phone number ID, product type, or calling name fields to update, used with the <a>BatchUpdatePhoneNumber</a> and
 * <a>UpdatePhoneNumber</a> actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePhoneNumberRequestItem implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdatePhoneNumberRequestItem.Builder, UpdatePhoneNumberRequestItem> {
    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberId").getter(getter(UpdatePhoneNumberRequestItem::phoneNumberId))
            .setter(setter(Builder::phoneNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberId").build()).build();

    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductType").getter(getter(UpdatePhoneNumberRequestItem::productTypeAsString))
            .setter(setter(Builder::productType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductType").build()).build();

    private static final SdkField<String> CALLING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallingName").getter(getter(UpdatePhoneNumberRequestItem::callingName))
            .setter(setter(Builder::callingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ID_FIELD,
            PRODUCT_TYPE_FIELD, CALLING_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String phoneNumberId;

    private final String productType;

    private final String callingName;

    private UpdatePhoneNumberRequestItem(BuilderImpl builder) {
        this.phoneNumberId = builder.phoneNumberId;
        this.productType = builder.productType;
        this.callingName = builder.callingName;
    }

    /**
     * <p>
     * The phone number ID to update.
     * </p>
     * 
     * @return The phone number ID to update.
     */
    public final String phoneNumberId() {
        return phoneNumberId;
    }

    /**
     * <p>
     * The product type to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link PhoneNumberProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The product type to update.
     * @see PhoneNumberProductType
     */
    public final PhoneNumberProductType productType() {
        return PhoneNumberProductType.fromValue(productType);
    }

    /**
     * <p>
     * The product type to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link PhoneNumberProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The product type to update.
     * @see PhoneNumberProductType
     */
    public final String productTypeAsString() {
        return productType;
    }

    /**
     * <p>
     * The outbound calling name to update.
     * </p>
     * 
     * @return The outbound calling name to update.
     */
    public final String callingName() {
        return callingName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(callingName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePhoneNumberRequestItem)) {
            return false;
        }
        UpdatePhoneNumberRequestItem other = (UpdatePhoneNumberRequestItem) obj;
        return Objects.equals(phoneNumberId(), other.phoneNumberId())
                && Objects.equals(productTypeAsString(), other.productTypeAsString())
                && Objects.equals(callingName(), other.callingName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePhoneNumberRequestItem").add("PhoneNumberId", phoneNumberId())
                .add("ProductType", productTypeAsString())
                .add("CallingName", callingName() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberId":
            return Optional.ofNullable(clazz.cast(phoneNumberId()));
        case "ProductType":
            return Optional.ofNullable(clazz.cast(productTypeAsString()));
        case "CallingName":
            return Optional.ofNullable(clazz.cast(callingName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PhoneNumberId", PHONE_NUMBER_ID_FIELD);
        map.put("ProductType", PRODUCT_TYPE_FIELD);
        map.put("CallingName", CALLING_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePhoneNumberRequestItem, T> g) {
        return obj -> g.apply((UpdatePhoneNumberRequestItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdatePhoneNumberRequestItem> {
        /**
         * <p>
         * The phone number ID to update.
         * </p>
         * 
         * @param phoneNumberId
         *        The phone number ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberId(String phoneNumberId);

        /**
         * <p>
         * The product type to update.
         * </p>
         * 
         * @param productType
         *        The product type to update.
         * @see PhoneNumberProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberProductType
         */
        Builder productType(String productType);

        /**
         * <p>
         * The product type to update.
         * </p>
         * 
         * @param productType
         *        The product type to update.
         * @see PhoneNumberProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberProductType
         */
        Builder productType(PhoneNumberProductType productType);

        /**
         * <p>
         * The outbound calling name to update.
         * </p>
         * 
         * @param callingName
         *        The outbound calling name to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callingName(String callingName);
    }

    static final class BuilderImpl implements Builder {
        private String phoneNumberId;

        private String productType;

        private String callingName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePhoneNumberRequestItem model) {
            phoneNumberId(model.phoneNumberId);
            productType(model.productType);
            callingName(model.callingName);
        }

        public final String getPhoneNumberId() {
            return phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final String getProductType() {
            return productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(PhoneNumberProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final String getCallingName() {
            return callingName;
        }

        public final void setCallingName(String callingName) {
            this.callingName = callingName;
        }

        @Override
        public final Builder callingName(String callingName) {
            this.callingName = callingName;
            return this;
        }

        @Override
        public UpdatePhoneNumberRequestItem build() {
            return new UpdatePhoneNumberRequestItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
