/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRetentionSettingsRequest extends ChimeRequest implements
        ToCopyableBuilder<PutRetentionSettingsRequest.Builder, PutRetentionSettingsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(PutRetentionSettingsRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()).build();

    private static final SdkField<RetentionSettings> RETENTION_SETTINGS_FIELD = SdkField
            .<RetentionSettings> builder(MarshallingType.SDK_POJO).memberName("RetentionSettings")
            .getter(getter(PutRetentionSettingsRequest::retentionSettings)).setter(setter(Builder::retentionSettings))
            .constructor(RetentionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            RETENTION_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final RetentionSettings retentionSettings;

    private PutRetentionSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.retentionSettings = builder.retentionSettings;
    }

    /**
     * <p>
     * The Amazon Chime account ID.
     * </p>
     * 
     * @return The Amazon Chime account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The retention settings.
     * </p>
     * 
     * @return The retention settings.
     */
    public final RetentionSettings retentionSettings() {
        return retentionSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(retentionSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRetentionSettingsRequest)) {
            return false;
        }
        PutRetentionSettingsRequest other = (PutRetentionSettingsRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(retentionSettings(), other.retentionSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRetentionSettingsRequest").add("AccountId", accountId())
                .add("RetentionSettings", retentionSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "RetentionSettings":
            return Optional.ofNullable(clazz.cast(retentionSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("RetentionSettings", RETENTION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRetentionSettingsRequest, T> g) {
        return obj -> g.apply((PutRetentionSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutRetentionSettingsRequest> {
        /**
         * <p>
         * The Amazon Chime account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Chime account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The retention settings.
         * </p>
         * 
         * @param retentionSettings
         *        The retention settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionSettings(RetentionSettings retentionSettings);

        /**
         * <p>
         * The retention settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionSettings.Builder} avoiding the
         * need to create one manually via {@link RetentionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionSettings(RetentionSettings)}.
         * 
         * @param retentionSettings
         *        a consumer that will call methods on {@link RetentionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionSettings(RetentionSettings)
         */
        default Builder retentionSettings(Consumer<RetentionSettings.Builder> retentionSettings) {
            return retentionSettings(RetentionSettings.builder().applyMutation(retentionSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String accountId;

        private RetentionSettings retentionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRetentionSettingsRequest model) {
            super(model);
            accountId(model.accountId);
            retentionSettings(model.retentionSettings);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final RetentionSettings.Builder getRetentionSettings() {
            return retentionSettings != null ? retentionSettings.toBuilder() : null;
        }

        public final void setRetentionSettings(RetentionSettings.BuilderImpl retentionSettings) {
            this.retentionSettings = retentionSettings != null ? retentionSettings.build() : null;
        }

        @Override
        public final Builder retentionSettings(RetentionSettings retentionSettings) {
            this.retentionSettings = retentionSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRetentionSettingsRequest build() {
            return new PutRetentionSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
