/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.model.ListUsersRequest;
import software.amazon.awssdk.services.chime.model.ListUsersResponse;

public class ListUsersIterable
implements SdkIterable<ListUsersResponse> {
    private final ChimeClient client;
    private final ListUsersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUsersIterable(ChimeClient client, ListUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUsersResponseFetcher();
    }

    public Iterator<ListUsersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListUsersIterable resume(ListUsersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListUsersIterable(this.client, (ListUsersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListUsersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListUsersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListUsersResponseFetcher
    implements SyncPageFetcher<ListUsersResponse> {
        private ListUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUsersResponse nextPage(ListUsersResponse previousPage) {
            if (previousPage == null) {
                return ListUsersIterable.this.client.listUsers(ListUsersIterable.this.firstRequest);
            }
            return ListUsersIterable.this.client.listUsers((ListUsersRequest)((Object)ListUsersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

