/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.AlexaForBusinessMetadata;
import software.amazon.awssdk.services.chime.model.License;
import software.amazon.awssdk.services.chime.model.UserType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserRequestItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateUserRequestItem> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(UpdateUserRequestItem.getter(UpdateUserRequestItem::userId)).setter(UpdateUserRequestItem.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseType").getter(UpdateUserRequestItem.getter(UpdateUserRequestItem::licenseTypeAsString)).setter(UpdateUserRequestItem.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType").build()}).build();
    private static final SdkField<String> USER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserType").getter(UpdateUserRequestItem.getter(UpdateUserRequestItem::userTypeAsString)).setter(UpdateUserRequestItem.setter(Builder::userType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserType").build()}).build();
    private static final SdkField<AlexaForBusinessMetadata> ALEXA_FOR_BUSINESS_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlexaForBusinessMetadata").getter(UpdateUserRequestItem.getter(UpdateUserRequestItem::alexaForBusinessMetadata)).setter(UpdateUserRequestItem.setter(Builder::alexaForBusinessMetadata)).constructor(AlexaForBusinessMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlexaForBusinessMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, LICENSE_TYPE_FIELD, USER_TYPE_FIELD, ALEXA_FOR_BUSINESS_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateUserRequestItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String userId;
    private final String licenseType;
    private final String userType;
    private final AlexaForBusinessMetadata alexaForBusinessMetadata;

    private UpdateUserRequestItem(BuilderImpl builder) {
        this.userId = builder.userId;
        this.licenseType = builder.licenseType;
        this.userType = builder.userType;
        this.alexaForBusinessMetadata = builder.alexaForBusinessMetadata;
    }

    public final String userId() {
        return this.userId;
    }

    public final License licenseType() {
        return License.fromValue(this.licenseType);
    }

    public final String licenseTypeAsString() {
        return this.licenseType;
    }

    public final UserType userType() {
        return UserType.fromValue(this.userType);
    }

    public final String userTypeAsString() {
        return this.userType;
    }

    public final AlexaForBusinessMetadata alexaForBusinessMetadata() {
        return this.alexaForBusinessMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.alexaForBusinessMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequestItem)) {
            return false;
        }
        UpdateUserRequestItem other = (UpdateUserRequestItem)obj;
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(this.userTypeAsString(), other.userTypeAsString()) && Objects.equals(this.alexaForBusinessMetadata(), other.alexaForBusinessMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserRequestItem").add("UserId", (Object)this.userId()).add("LicenseType", (Object)this.licenseTypeAsString()).add("UserType", (Object)this.userTypeAsString()).add("AlexaForBusinessMetadata", (Object)this.alexaForBusinessMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "LicenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "UserType": {
                return Optional.ofNullable(clazz.cast(this.userTypeAsString()));
            }
            case "AlexaForBusinessMetadata": {
                return Optional.ofNullable(clazz.cast(this.alexaForBusinessMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserId", USER_ID_FIELD);
        map.put("LicenseType", LICENSE_TYPE_FIELD);
        map.put("UserType", USER_TYPE_FIELD);
        map.put("AlexaForBusinessMetadata", ALEXA_FOR_BUSINESS_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequestItem, T> g) {
        return obj -> g.apply((UpdateUserRequestItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userId;
        private String licenseType;
        private String userType;
        private AlexaForBusinessMetadata alexaForBusinessMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequestItem model) {
            this.userId(model.userId);
            this.licenseType(model.licenseType);
            this.userType(model.userType);
            this.alexaForBusinessMetadata(model.alexaForBusinessMetadata);
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(License licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final String getUserType() {
            return this.userType;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        @Override
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        @Override
        public final Builder userType(UserType userType) {
            this.userType(userType == null ? null : userType.toString());
            return this;
        }

        public final AlexaForBusinessMetadata.Builder getAlexaForBusinessMetadata() {
            return this.alexaForBusinessMetadata != null ? this.alexaForBusinessMetadata.toBuilder() : null;
        }

        public final void setAlexaForBusinessMetadata(AlexaForBusinessMetadata.BuilderImpl alexaForBusinessMetadata) {
            this.alexaForBusinessMetadata = alexaForBusinessMetadata != null ? alexaForBusinessMetadata.build() : null;
        }

        @Override
        public final Builder alexaForBusinessMetadata(AlexaForBusinessMetadata alexaForBusinessMetadata) {
            this.alexaForBusinessMetadata = alexaForBusinessMetadata;
            return this;
        }

        public UpdateUserRequestItem build() {
            return new UpdateUserRequestItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateUserRequestItem> {
        public Builder userId(String var1);

        public Builder licenseType(String var1);

        public Builder licenseType(License var1);

        public Builder userType(String var1);

        public Builder userType(UserType var1);

        public Builder alexaForBusinessMetadata(AlexaForBusinessMetadata var1);

        default public Builder alexaForBusinessMetadata(Consumer<AlexaForBusinessMetadata.Builder> alexaForBusinessMetadata) {
            return this.alexaForBusinessMetadata((AlexaForBusinessMetadata)((AlexaForBusinessMetadata.Builder)AlexaForBusinessMetadata.builder().applyMutation(alexaForBusinessMetadata)).build());
        }
    }
}

