/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.SipRuleTargetApplication;
import software.amazon.awssdk.services.chime.model.SipRuleTargetApplicationListCopier;
import software.amazon.awssdk.services.chime.model.SipRuleTriggerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSipRuleRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, CreateSipRuleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateSipRuleRequest.getter(CreateSipRuleRequest::name)).setter(CreateSipRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TRIGGER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TriggerType").getter(CreateSipRuleRequest.getter(CreateSipRuleRequest::triggerTypeAsString)).setter(CreateSipRuleRequest.setter(Builder::triggerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerType").build()}).build();
    private static final SdkField<String> TRIGGER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TriggerValue").getter(CreateSipRuleRequest.getter(CreateSipRuleRequest::triggerValue)).setter(CreateSipRuleRequest.setter(Builder::triggerValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerValue").build()}).build();
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Disabled").getter(CreateSipRuleRequest.getter(CreateSipRuleRequest::disabled)).setter(CreateSipRuleRequest.setter(Builder::disabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()}).build();
    private static final SdkField<List<SipRuleTargetApplication>> TARGET_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetApplications").getter(CreateSipRuleRequest.getter(CreateSipRuleRequest::targetApplications)).setter(CreateSipRuleRequest.setter(Builder::targetApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SipRuleTargetApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TRIGGER_TYPE_FIELD, TRIGGER_VALUE_FIELD, DISABLED_FIELD, TARGET_APPLICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSipRuleRequest.memberNameToFieldInitializer();
    private final String name;
    private final String triggerType;
    private final String triggerValue;
    private final Boolean disabled;
    private final List<SipRuleTargetApplication> targetApplications;

    private CreateSipRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.triggerType = builder.triggerType;
        this.triggerValue = builder.triggerValue;
        this.disabled = builder.disabled;
        this.targetApplications = builder.targetApplications;
    }

    public final String name() {
        return this.name;
    }

    public final SipRuleTriggerType triggerType() {
        return SipRuleTriggerType.fromValue(this.triggerType);
    }

    public final String triggerTypeAsString() {
        return this.triggerType;
    }

    public final String triggerValue() {
        return this.triggerValue;
    }

    public final Boolean disabled() {
        return this.disabled;
    }

    public final boolean hasTargetApplications() {
        return this.targetApplications != null && !(this.targetApplications instanceof SdkAutoConstructList);
    }

    public final List<SipRuleTargetApplication> targetApplications() {
        return this.targetApplications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetApplications() ? this.targetApplications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSipRuleRequest)) {
            return false;
        }
        CreateSipRuleRequest other = (CreateSipRuleRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.triggerTypeAsString(), other.triggerTypeAsString()) && Objects.equals(this.triggerValue(), other.triggerValue()) && Objects.equals(this.disabled(), other.disabled()) && this.hasTargetApplications() == other.hasTargetApplications() && Objects.equals(this.targetApplications(), other.targetApplications());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSipRuleRequest").add("Name", (Object)this.name()).add("TriggerType", (Object)this.triggerTypeAsString()).add("TriggerValue", (Object)this.triggerValue()).add("Disabled", (Object)this.disabled()).add("TargetApplications", this.hasTargetApplications() ? this.targetApplications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TriggerType": {
                return Optional.ofNullable(clazz.cast(this.triggerTypeAsString()));
            }
            case "TriggerValue": {
                return Optional.ofNullable(clazz.cast(this.triggerValue()));
            }
            case "Disabled": {
                return Optional.ofNullable(clazz.cast(this.disabled()));
            }
            case "TargetApplications": {
                return Optional.ofNullable(clazz.cast(this.targetApplications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("TriggerType", TRIGGER_TYPE_FIELD);
        map.put("TriggerValue", TRIGGER_VALUE_FIELD);
        map.put("Disabled", DISABLED_FIELD);
        map.put("TargetApplications", TARGET_APPLICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSipRuleRequest, T> g) {
        return obj -> g.apply((CreateSipRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String name;
        private String triggerType;
        private String triggerValue;
        private Boolean disabled;
        private List<SipRuleTargetApplication> targetApplications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSipRuleRequest model) {
            super(model);
            this.name(model.name);
            this.triggerType(model.triggerType);
            this.triggerValue(model.triggerValue);
            this.disabled(model.disabled);
            this.targetApplications(model.targetApplications);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTriggerType() {
            return this.triggerType;
        }

        public final void setTriggerType(String triggerType) {
            this.triggerType = triggerType;
        }

        @Override
        public final Builder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        @Override
        public final Builder triggerType(SipRuleTriggerType triggerType) {
            this.triggerType(triggerType == null ? null : triggerType.toString());
            return this;
        }

        public final String getTriggerValue() {
            return this.triggerValue;
        }

        public final void setTriggerValue(String triggerValue) {
            this.triggerValue = triggerValue;
        }

        @Override
        public final Builder triggerValue(String triggerValue) {
            this.triggerValue = triggerValue;
            return this;
        }

        public final Boolean getDisabled() {
            return this.disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final List<SipRuleTargetApplication.Builder> getTargetApplications() {
            List<SipRuleTargetApplication.Builder> result = SipRuleTargetApplicationListCopier.copyToBuilder(this.targetApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetApplications(Collection<SipRuleTargetApplication.BuilderImpl> targetApplications) {
            this.targetApplications = SipRuleTargetApplicationListCopier.copyFromBuilder(targetApplications);
        }

        @Override
        public final Builder targetApplications(Collection<SipRuleTargetApplication> targetApplications) {
            this.targetApplications = SipRuleTargetApplicationListCopier.copy(targetApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetApplications(SipRuleTargetApplication ... targetApplications) {
            this.targetApplications(Arrays.asList(targetApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetApplications(Consumer<SipRuleTargetApplication.Builder> ... targetApplications) {
            this.targetApplications(Stream.of(targetApplications).map(c -> (SipRuleTargetApplication)((SipRuleTargetApplication.Builder)SipRuleTargetApplication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSipRuleRequest build() {
            return new CreateSipRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSipRuleRequest> {
        public Builder name(String var1);

        public Builder triggerType(String var1);

        public Builder triggerType(SipRuleTriggerType var1);

        public Builder triggerValue(String var1);

        public Builder disabled(Boolean var1);

        public Builder targetApplications(Collection<SipRuleTargetApplication> var1);

        public Builder targetApplications(SipRuleTargetApplication ... var1);

        public Builder targetApplications(Consumer<SipRuleTargetApplication.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

