/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeAsyncClient;
import software.amazon.awssdk.services.chime.internal.UserAgentUtils;
import software.amazon.awssdk.services.chime.model.ListChannelMembershipsForAppInstanceUserRequest;
import software.amazon.awssdk.services.chime.model.ListChannelMembershipsForAppInstanceUserResponse;

public class ListChannelMembershipsForAppInstanceUserPublisher
implements SdkPublisher<ListChannelMembershipsForAppInstanceUserResponse> {
    private final ChimeAsyncClient client;
    private final ListChannelMembershipsForAppInstanceUserRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChannelMembershipsForAppInstanceUserPublisher(ChimeAsyncClient client, ListChannelMembershipsForAppInstanceUserRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChannelMembershipsForAppInstanceUserPublisher(ChimeAsyncClient client, ListChannelMembershipsForAppInstanceUserRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChannelMembershipsForAppInstanceUserResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChannelMembershipsForAppInstanceUserResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListChannelMembershipsForAppInstanceUserResponseFetcher
    implements AsyncPageFetcher<ListChannelMembershipsForAppInstanceUserResponse> {
        private ListChannelMembershipsForAppInstanceUserResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelMembershipsForAppInstanceUserResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChannelMembershipsForAppInstanceUserResponse> nextPage(ListChannelMembershipsForAppInstanceUserResponse previousPage) {
            if (previousPage == null) {
                return ListChannelMembershipsForAppInstanceUserPublisher.this.client.listChannelMembershipsForAppInstanceUser(ListChannelMembershipsForAppInstanceUserPublisher.this.firstRequest);
            }
            return ListChannelMembershipsForAppInstanceUserPublisher.this.client.listChannelMembershipsForAppInstanceUser((ListChannelMembershipsForAppInstanceUserRequest)((Object)ListChannelMembershipsForAppInstanceUserPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

