/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.CallingRegionListCopier;
import software.amazon.awssdk.services.chime.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Termination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Termination> {
    private static final SdkField<Integer> CPS_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CpsLimit").getter(Termination.getter(Termination::cpsLimit)).setter(Termination.setter(Builder::cpsLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpsLimit").build()}).build();
    private static final SdkField<String> DEFAULT_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultPhoneNumber").getter(Termination.getter(Termination::defaultPhoneNumber)).setter(Termination.setter(Builder::defaultPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultPhoneNumber").build()}).build();
    private static final SdkField<List<String>> CALLING_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CallingRegions").getter(Termination.getter(Termination::callingRegions)).setter(Termination.setter(Builder::callingRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CIDR_ALLOWED_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrAllowedList").getter(Termination.getter(Termination::cidrAllowedList)).setter(Termination.setter(Builder::cidrAllowedList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrAllowedList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Disabled").getter(Termination.getter(Termination::disabled)).setter(Termination.setter(Builder::disabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPS_LIMIT_FIELD, DEFAULT_PHONE_NUMBER_FIELD, CALLING_REGIONS_FIELD, CIDR_ALLOWED_LIST_FIELD, DISABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Termination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer cpsLimit;
    private final String defaultPhoneNumber;
    private final List<String> callingRegions;
    private final List<String> cidrAllowedList;
    private final Boolean disabled;

    private Termination(BuilderImpl builder) {
        this.cpsLimit = builder.cpsLimit;
        this.defaultPhoneNumber = builder.defaultPhoneNumber;
        this.callingRegions = builder.callingRegions;
        this.cidrAllowedList = builder.cidrAllowedList;
        this.disabled = builder.disabled;
    }

    public final Integer cpsLimit() {
        return this.cpsLimit;
    }

    public final String defaultPhoneNumber() {
        return this.defaultPhoneNumber;
    }

    public final boolean hasCallingRegions() {
        return this.callingRegions != null && !(this.callingRegions instanceof SdkAutoConstructList);
    }

    public final List<String> callingRegions() {
        return this.callingRegions;
    }

    public final boolean hasCidrAllowedList() {
        return this.cidrAllowedList != null && !(this.cidrAllowedList instanceof SdkAutoConstructList);
    }

    public final List<String> cidrAllowedList() {
        return this.cidrAllowedList;
    }

    public final Boolean disabled() {
        return this.disabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cpsLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCallingRegions() ? this.callingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrAllowedList() ? this.cidrAllowedList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.disabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Termination)) {
            return false;
        }
        Termination other = (Termination)obj;
        return Objects.equals(this.cpsLimit(), other.cpsLimit()) && Objects.equals(this.defaultPhoneNumber(), other.defaultPhoneNumber()) && this.hasCallingRegions() == other.hasCallingRegions() && Objects.equals(this.callingRegions(), other.callingRegions()) && this.hasCidrAllowedList() == other.hasCidrAllowedList() && Objects.equals(this.cidrAllowedList(), other.cidrAllowedList()) && Objects.equals(this.disabled(), other.disabled());
    }

    public final String toString() {
        return ToString.builder((String)"Termination").add("CpsLimit", (Object)this.cpsLimit()).add("DefaultPhoneNumber", (Object)(this.defaultPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("CallingRegions", this.hasCallingRegions() ? this.callingRegions() : null).add("CidrAllowedList", this.hasCidrAllowedList() ? this.cidrAllowedList() : null).add("Disabled", (Object)this.disabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CpsLimit": {
                return Optional.ofNullable(clazz.cast(this.cpsLimit()));
            }
            case "DefaultPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.defaultPhoneNumber()));
            }
            case "CallingRegions": {
                return Optional.ofNullable(clazz.cast(this.callingRegions()));
            }
            case "CidrAllowedList": {
                return Optional.ofNullable(clazz.cast(this.cidrAllowedList()));
            }
            case "Disabled": {
                return Optional.ofNullable(clazz.cast(this.disabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CpsLimit", CPS_LIMIT_FIELD);
        map.put("DefaultPhoneNumber", DEFAULT_PHONE_NUMBER_FIELD);
        map.put("CallingRegions", CALLING_REGIONS_FIELD);
        map.put("CidrAllowedList", CIDR_ALLOWED_LIST_FIELD);
        map.put("Disabled", DISABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Termination, T> g) {
        return obj -> g.apply((Termination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer cpsLimit;
        private String defaultPhoneNumber;
        private List<String> callingRegions = DefaultSdkAutoConstructList.getInstance();
        private List<String> cidrAllowedList = DefaultSdkAutoConstructList.getInstance();
        private Boolean disabled;

        private BuilderImpl() {
        }

        private BuilderImpl(Termination model) {
            this.cpsLimit(model.cpsLimit);
            this.defaultPhoneNumber(model.defaultPhoneNumber);
            this.callingRegions(model.callingRegions);
            this.cidrAllowedList(model.cidrAllowedList);
            this.disabled(model.disabled);
        }

        public final Integer getCpsLimit() {
            return this.cpsLimit;
        }

        public final void setCpsLimit(Integer cpsLimit) {
            this.cpsLimit = cpsLimit;
        }

        @Override
        public final Builder cpsLimit(Integer cpsLimit) {
            this.cpsLimit = cpsLimit;
            return this;
        }

        public final String getDefaultPhoneNumber() {
            return this.defaultPhoneNumber;
        }

        public final void setDefaultPhoneNumber(String defaultPhoneNumber) {
            this.defaultPhoneNumber = defaultPhoneNumber;
        }

        @Override
        public final Builder defaultPhoneNumber(String defaultPhoneNumber) {
            this.defaultPhoneNumber = defaultPhoneNumber;
            return this;
        }

        public final Collection<String> getCallingRegions() {
            if (this.callingRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.callingRegions;
        }

        public final void setCallingRegions(Collection<String> callingRegions) {
            this.callingRegions = CallingRegionListCopier.copy(callingRegions);
        }

        @Override
        public final Builder callingRegions(Collection<String> callingRegions) {
            this.callingRegions = CallingRegionListCopier.copy(callingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callingRegions(String ... callingRegions) {
            this.callingRegions(Arrays.asList(callingRegions));
            return this;
        }

        public final Collection<String> getCidrAllowedList() {
            if (this.cidrAllowedList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrAllowedList;
        }

        public final void setCidrAllowedList(Collection<String> cidrAllowedList) {
            this.cidrAllowedList = StringListCopier.copy(cidrAllowedList);
        }

        @Override
        public final Builder cidrAllowedList(Collection<String> cidrAllowedList) {
            this.cidrAllowedList = StringListCopier.copy(cidrAllowedList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrAllowedList(String ... cidrAllowedList) {
            this.cidrAllowedList(Arrays.asList(cidrAllowedList));
            return this;
        }

        public final Boolean getDisabled() {
            return this.disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public Termination build() {
            return new Termination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Termination> {
        public Builder cpsLimit(Integer var1);

        public Builder defaultPhoneNumber(String var1);

        public Builder callingRegions(Collection<String> var1);

        public Builder callingRegions(String ... var1);

        public Builder cidrAllowedList(Collection<String> var1);

        public Builder cidrAllowedList(String ... var1);

        public Builder disabled(Boolean var1);
    }
}

