/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.AppInstanceDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppInstanceStreamingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppInstanceStreamingConfiguration> {
    private static final SdkField<String> APP_INSTANCE_DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceDataType").getter(AppInstanceStreamingConfiguration.getter(AppInstanceStreamingConfiguration::appInstanceDataTypeAsString)).setter(AppInstanceStreamingConfiguration.setter(Builder::appInstanceDataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceDataType").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(AppInstanceStreamingConfiguration.getter(AppInstanceStreamingConfiguration::resourceArn)).setter(AppInstanceStreamingConfiguration.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_DATA_TYPE_FIELD, RESOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AppInstanceDataType", APP_INSTANCE_DATA_TYPE_FIELD);
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String appInstanceDataType;
    private final String resourceArn;

    private AppInstanceStreamingConfiguration(BuilderImpl builder) {
        this.appInstanceDataType = builder.appInstanceDataType;
        this.resourceArn = builder.resourceArn;
    }

    public final AppInstanceDataType appInstanceDataType() {
        return AppInstanceDataType.fromValue(this.appInstanceDataType);
    }

    public final String appInstanceDataTypeAsString() {
        return this.appInstanceDataType;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceDataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInstanceStreamingConfiguration)) {
            return false;
        }
        AppInstanceStreamingConfiguration other = (AppInstanceStreamingConfiguration)obj;
        return Objects.equals(this.appInstanceDataTypeAsString(), other.appInstanceDataTypeAsString()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"AppInstanceStreamingConfiguration").add("AppInstanceDataType", (Object)this.appInstanceDataTypeAsString()).add("ResourceArn", (Object)(this.resourceArn() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppInstanceDataType": {
                return Optional.ofNullable(clazz.cast(this.appInstanceDataTypeAsString()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AppInstanceStreamingConfiguration, T> g) {
        return obj -> g.apply((AppInstanceStreamingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appInstanceDataType;
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInstanceStreamingConfiguration model) {
            this.appInstanceDataType(model.appInstanceDataType);
            this.resourceArn(model.resourceArn);
        }

        public final String getAppInstanceDataType() {
            return this.appInstanceDataType;
        }

        public final void setAppInstanceDataType(String appInstanceDataType) {
            this.appInstanceDataType = appInstanceDataType;
        }

        @Override
        public final Builder appInstanceDataType(String appInstanceDataType) {
            this.appInstanceDataType = appInstanceDataType;
            return this;
        }

        @Override
        public final Builder appInstanceDataType(AppInstanceDataType appInstanceDataType) {
            this.appInstanceDataType(appInstanceDataType == null ? null : appInstanceDataType.toString());
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public AppInstanceStreamingConfiguration build() {
            return new AppInstanceStreamingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppInstanceStreamingConfiguration> {
        public Builder appInstanceDataType(String var1);

        public Builder appInstanceDataType(AppInstanceDataType var1);

        public Builder resourceArn(String var1);
    }
}

