/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.AlexaForBusinessMetadata;
import software.amazon.awssdk.services.chime.model.InviteStatus;
import software.amazon.awssdk.services.chime.model.License;
import software.amazon.awssdk.services.chime.model.RegistrationStatus;
import software.amazon.awssdk.services.chime.model.UserType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class User
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, User> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(User.getter(User::userId)).setter(User.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(User.getter(User::accountId)).setter(User.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> PRIMARY_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryEmail").getter(User.getter(User::primaryEmail)).setter(User.setter(Builder::primaryEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryEmail").build()}).build();
    private static final SdkField<String> PRIMARY_PROVISIONED_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryProvisionedNumber").getter(User.getter(User::primaryProvisionedNumber)).setter(User.setter(Builder::primaryProvisionedNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryProvisionedNumber").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(User.getter(User::displayName)).setter(User.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseType").getter(User.getter(User::licenseTypeAsString)).setter(User.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType").build()}).build();
    private static final SdkField<String> USER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserType").getter(User.getter(User::userTypeAsString)).setter(User.setter(Builder::userType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserType").build()}).build();
    private static final SdkField<String> USER_REGISTRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserRegistrationStatus").getter(User.getter(User::userRegistrationStatusAsString)).setter(User.setter(Builder::userRegistrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRegistrationStatus").build()}).build();
    private static final SdkField<String> USER_INVITATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserInvitationStatus").getter(User.getter(User::userInvitationStatusAsString)).setter(User.setter(Builder::userInvitationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInvitationStatus").build()}).build();
    private static final SdkField<Instant> REGISTERED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RegisteredOn").getter(User.getter(User::registeredOn)).setter(User.setter(Builder::registeredOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredOn").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> INVITED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InvitedOn").getter(User.getter(User::invitedOn)).setter(User.setter(Builder::invitedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitedOn").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<AlexaForBusinessMetadata> ALEXA_FOR_BUSINESS_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlexaForBusinessMetadata").getter(User.getter(User::alexaForBusinessMetadata)).setter(User.setter(Builder::alexaForBusinessMetadata)).constructor(AlexaForBusinessMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlexaForBusinessMetadata").build()}).build();
    private static final SdkField<String> PERSONAL_PIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PersonalPIN").getter(User.getter(User::personalPIN)).setter(User.setter(Builder::personalPIN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalPIN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, ACCOUNT_ID_FIELD, PRIMARY_EMAIL_FIELD, PRIMARY_PROVISIONED_NUMBER_FIELD, DISPLAY_NAME_FIELD, LICENSE_TYPE_FIELD, USER_TYPE_FIELD, USER_REGISTRATION_STATUS_FIELD, USER_INVITATION_STATUS_FIELD, REGISTERED_ON_FIELD, INVITED_ON_FIELD, ALEXA_FOR_BUSINESS_METADATA_FIELD, PERSONAL_PIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserId", USER_ID_FIELD);
            this.put("AccountId", ACCOUNT_ID_FIELD);
            this.put("PrimaryEmail", PRIMARY_EMAIL_FIELD);
            this.put("PrimaryProvisionedNumber", PRIMARY_PROVISIONED_NUMBER_FIELD);
            this.put("DisplayName", DISPLAY_NAME_FIELD);
            this.put("LicenseType", LICENSE_TYPE_FIELD);
            this.put("UserType", USER_TYPE_FIELD);
            this.put("UserRegistrationStatus", USER_REGISTRATION_STATUS_FIELD);
            this.put("UserInvitationStatus", USER_INVITATION_STATUS_FIELD);
            this.put("RegisteredOn", REGISTERED_ON_FIELD);
            this.put("InvitedOn", INVITED_ON_FIELD);
            this.put("AlexaForBusinessMetadata", ALEXA_FOR_BUSINESS_METADATA_FIELD);
            this.put("PersonalPIN", PERSONAL_PIN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String userId;
    private final String accountId;
    private final String primaryEmail;
    private final String primaryProvisionedNumber;
    private final String displayName;
    private final String licenseType;
    private final String userType;
    private final String userRegistrationStatus;
    private final String userInvitationStatus;
    private final Instant registeredOn;
    private final Instant invitedOn;
    private final AlexaForBusinessMetadata alexaForBusinessMetadata;
    private final String personalPIN;

    private User(BuilderImpl builder) {
        this.userId = builder.userId;
        this.accountId = builder.accountId;
        this.primaryEmail = builder.primaryEmail;
        this.primaryProvisionedNumber = builder.primaryProvisionedNumber;
        this.displayName = builder.displayName;
        this.licenseType = builder.licenseType;
        this.userType = builder.userType;
        this.userRegistrationStatus = builder.userRegistrationStatus;
        this.userInvitationStatus = builder.userInvitationStatus;
        this.registeredOn = builder.registeredOn;
        this.invitedOn = builder.invitedOn;
        this.alexaForBusinessMetadata = builder.alexaForBusinessMetadata;
        this.personalPIN = builder.personalPIN;
    }

    public final String userId() {
        return this.userId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String primaryEmail() {
        return this.primaryEmail;
    }

    public final String primaryProvisionedNumber() {
        return this.primaryProvisionedNumber;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final License licenseType() {
        return License.fromValue(this.licenseType);
    }

    public final String licenseTypeAsString() {
        return this.licenseType;
    }

    public final UserType userType() {
        return UserType.fromValue(this.userType);
    }

    public final String userTypeAsString() {
        return this.userType;
    }

    public final RegistrationStatus userRegistrationStatus() {
        return RegistrationStatus.fromValue(this.userRegistrationStatus);
    }

    public final String userRegistrationStatusAsString() {
        return this.userRegistrationStatus;
    }

    public final InviteStatus userInvitationStatus() {
        return InviteStatus.fromValue(this.userInvitationStatus);
    }

    public final String userInvitationStatusAsString() {
        return this.userInvitationStatus;
    }

    public final Instant registeredOn() {
        return this.registeredOn;
    }

    public final Instant invitedOn() {
        return this.invitedOn;
    }

    public final AlexaForBusinessMetadata alexaForBusinessMetadata() {
        return this.alexaForBusinessMetadata;
    }

    public final String personalPIN() {
        return this.personalPIN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryProvisionedNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userRegistrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userInvitationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alexaForBusinessMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.personalPIN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.primaryEmail(), other.primaryEmail()) && Objects.equals(this.primaryProvisionedNumber(), other.primaryProvisionedNumber()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(this.userTypeAsString(), other.userTypeAsString()) && Objects.equals(this.userRegistrationStatusAsString(), other.userRegistrationStatusAsString()) && Objects.equals(this.userInvitationStatusAsString(), other.userInvitationStatusAsString()) && Objects.equals(this.registeredOn(), other.registeredOn()) && Objects.equals(this.invitedOn(), other.invitedOn()) && Objects.equals(this.alexaForBusinessMetadata(), other.alexaForBusinessMetadata()) && Objects.equals(this.personalPIN(), other.personalPIN());
    }

    public final String toString() {
        return ToString.builder((String)"User").add("UserId", (Object)this.userId()).add("AccountId", (Object)this.accountId()).add("PrimaryEmail", (Object)(this.primaryEmail() == null ? null : "*** Sensitive Data Redacted ***")).add("PrimaryProvisionedNumber", (Object)(this.primaryProvisionedNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("LicenseType", (Object)this.licenseTypeAsString()).add("UserType", (Object)this.userTypeAsString()).add("UserRegistrationStatus", (Object)this.userRegistrationStatusAsString()).add("UserInvitationStatus", (Object)this.userInvitationStatusAsString()).add("RegisteredOn", (Object)this.registeredOn()).add("InvitedOn", (Object)this.invitedOn()).add("AlexaForBusinessMetadata", (Object)this.alexaForBusinessMetadata()).add("PersonalPIN", (Object)this.personalPIN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "PrimaryEmail": {
                return Optional.ofNullable(clazz.cast(this.primaryEmail()));
            }
            case "PrimaryProvisionedNumber": {
                return Optional.ofNullable(clazz.cast(this.primaryProvisionedNumber()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "LicenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "UserType": {
                return Optional.ofNullable(clazz.cast(this.userTypeAsString()));
            }
            case "UserRegistrationStatus": {
                return Optional.ofNullable(clazz.cast(this.userRegistrationStatusAsString()));
            }
            case "UserInvitationStatus": {
                return Optional.ofNullable(clazz.cast(this.userInvitationStatusAsString()));
            }
            case "RegisteredOn": {
                return Optional.ofNullable(clazz.cast(this.registeredOn()));
            }
            case "InvitedOn": {
                return Optional.ofNullable(clazz.cast(this.invitedOn()));
            }
            case "AlexaForBusinessMetadata": {
                return Optional.ofNullable(clazz.cast(this.alexaForBusinessMetadata()));
            }
            case "PersonalPIN": {
                return Optional.ofNullable(clazz.cast(this.personalPIN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userId;
        private String accountId;
        private String primaryEmail;
        private String primaryProvisionedNumber;
        private String displayName;
        private String licenseType;
        private String userType;
        private String userRegistrationStatus;
        private String userInvitationStatus;
        private Instant registeredOn;
        private Instant invitedOn;
        private AlexaForBusinessMetadata alexaForBusinessMetadata;
        private String personalPIN;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            this.userId(model.userId);
            this.accountId(model.accountId);
            this.primaryEmail(model.primaryEmail);
            this.primaryProvisionedNumber(model.primaryProvisionedNumber);
            this.displayName(model.displayName);
            this.licenseType(model.licenseType);
            this.userType(model.userType);
            this.userRegistrationStatus(model.userRegistrationStatus);
            this.userInvitationStatus(model.userInvitationStatus);
            this.registeredOn(model.registeredOn);
            this.invitedOn(model.invitedOn);
            this.alexaForBusinessMetadata(model.alexaForBusinessMetadata);
            this.personalPIN(model.personalPIN);
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getPrimaryEmail() {
            return this.primaryEmail;
        }

        public final void setPrimaryEmail(String primaryEmail) {
            this.primaryEmail = primaryEmail;
        }

        @Override
        public final Builder primaryEmail(String primaryEmail) {
            this.primaryEmail = primaryEmail;
            return this;
        }

        public final String getPrimaryProvisionedNumber() {
            return this.primaryProvisionedNumber;
        }

        public final void setPrimaryProvisionedNumber(String primaryProvisionedNumber) {
            this.primaryProvisionedNumber = primaryProvisionedNumber;
        }

        @Override
        public final Builder primaryProvisionedNumber(String primaryProvisionedNumber) {
            this.primaryProvisionedNumber = primaryProvisionedNumber;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(License licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final String getUserType() {
            return this.userType;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        @Override
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        @Override
        public final Builder userType(UserType userType) {
            this.userType(userType == null ? null : userType.toString());
            return this;
        }

        public final String getUserRegistrationStatus() {
            return this.userRegistrationStatus;
        }

        public final void setUserRegistrationStatus(String userRegistrationStatus) {
            this.userRegistrationStatus = userRegistrationStatus;
        }

        @Override
        public final Builder userRegistrationStatus(String userRegistrationStatus) {
            this.userRegistrationStatus = userRegistrationStatus;
            return this;
        }

        @Override
        public final Builder userRegistrationStatus(RegistrationStatus userRegistrationStatus) {
            this.userRegistrationStatus(userRegistrationStatus == null ? null : userRegistrationStatus.toString());
            return this;
        }

        public final String getUserInvitationStatus() {
            return this.userInvitationStatus;
        }

        public final void setUserInvitationStatus(String userInvitationStatus) {
            this.userInvitationStatus = userInvitationStatus;
        }

        @Override
        public final Builder userInvitationStatus(String userInvitationStatus) {
            this.userInvitationStatus = userInvitationStatus;
            return this;
        }

        @Override
        public final Builder userInvitationStatus(InviteStatus userInvitationStatus) {
            this.userInvitationStatus(userInvitationStatus == null ? null : userInvitationStatus.toString());
            return this;
        }

        public final Instant getRegisteredOn() {
            return this.registeredOn;
        }

        public final void setRegisteredOn(Instant registeredOn) {
            this.registeredOn = registeredOn;
        }

        @Override
        public final Builder registeredOn(Instant registeredOn) {
            this.registeredOn = registeredOn;
            return this;
        }

        public final Instant getInvitedOn() {
            return this.invitedOn;
        }

        public final void setInvitedOn(Instant invitedOn) {
            this.invitedOn = invitedOn;
        }

        @Override
        public final Builder invitedOn(Instant invitedOn) {
            this.invitedOn = invitedOn;
            return this;
        }

        public final AlexaForBusinessMetadata.Builder getAlexaForBusinessMetadata() {
            return this.alexaForBusinessMetadata != null ? this.alexaForBusinessMetadata.toBuilder() : null;
        }

        public final void setAlexaForBusinessMetadata(AlexaForBusinessMetadata.BuilderImpl alexaForBusinessMetadata) {
            this.alexaForBusinessMetadata = alexaForBusinessMetadata != null ? alexaForBusinessMetadata.build() : null;
        }

        @Override
        public final Builder alexaForBusinessMetadata(AlexaForBusinessMetadata alexaForBusinessMetadata) {
            this.alexaForBusinessMetadata = alexaForBusinessMetadata;
            return this;
        }

        public final String getPersonalPIN() {
            return this.personalPIN;
        }

        public final void setPersonalPIN(String personalPIN) {
            this.personalPIN = personalPIN;
        }

        @Override
        public final Builder personalPIN(String personalPIN) {
            this.personalPIN = personalPIN;
            return this;
        }

        public User build() {
            return new User(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, User> {
        public Builder userId(String var1);

        public Builder accountId(String var1);

        public Builder primaryEmail(String var1);

        public Builder primaryProvisionedNumber(String var1);

        public Builder displayName(String var1);

        public Builder licenseType(String var1);

        public Builder licenseType(License var1);

        public Builder userType(String var1);

        public Builder userType(UserType var1);

        public Builder userRegistrationStatus(String var1);

        public Builder userRegistrationStatus(RegistrationStatus var1);

        public Builder userInvitationStatus(String var1);

        public Builder userInvitationStatus(InviteStatus var1);

        public Builder registeredOn(Instant var1);

        public Builder invitedOn(Instant var1);

        public Builder alexaForBusinessMetadata(AlexaForBusinessMetadata var1);

        default public Builder alexaForBusinessMetadata(Consumer<AlexaForBusinessMetadata.Builder> alexaForBusinessMetadata) {
            return this.alexaForBusinessMetadata((AlexaForBusinessMetadata)((AlexaForBusinessMetadata.Builder)AlexaForBusinessMetadata.builder().applyMutation(alexaForBusinessMetadata)).build());
        }

        public Builder personalPIN(String var1);
    }
}

