/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChannelMembershipSummary;
import software.amazon.awssdk.services.chime.model.ChannelMembershipSummaryListCopier;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChannelMembershipsResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListChannelMembershipsResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(ListChannelMembershipsResponse.getter(ListChannelMembershipsResponse::channelArn)).setter(ListChannelMembershipsResponse.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final SdkField<List<ChannelMembershipSummary>> CHANNEL_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelMemberships").getter(ListChannelMembershipsResponse.getter(ListChannelMembershipsResponse::channelMemberships)).setter(ListChannelMembershipsResponse.setter(Builder::channelMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelMemberships").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelMembershipSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListChannelMembershipsResponse.getter(ListChannelMembershipsResponse::nextToken)).setter(ListChannelMembershipsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, CHANNEL_MEMBERSHIPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ChannelArn", CHANNEL_ARN_FIELD);
            this.put("ChannelMemberships", CHANNEL_MEMBERSHIPS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String channelArn;
    private final List<ChannelMembershipSummary> channelMemberships;
    private final String nextToken;

    private ListChannelMembershipsResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.channelMemberships = builder.channelMemberships;
        this.nextToken = builder.nextToken;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final boolean hasChannelMemberships() {
        return this.channelMemberships != null && !(this.channelMemberships instanceof SdkAutoConstructList);
    }

    public final List<ChannelMembershipSummary> channelMemberships() {
        return this.channelMemberships;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelMemberships() ? this.channelMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelMembershipsResponse)) {
            return false;
        }
        ListChannelMembershipsResponse other = (ListChannelMembershipsResponse)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && this.hasChannelMemberships() == other.hasChannelMemberships() && Objects.equals(this.channelMemberships(), other.channelMemberships()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListChannelMembershipsResponse").add("ChannelArn", (Object)this.channelArn()).add("ChannelMemberships", this.hasChannelMemberships() ? this.channelMemberships() : null).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "ChannelMemberships": {
                return Optional.ofNullable(clazz.cast(this.channelMemberships()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelMembershipsResponse, T> g) {
        return obj -> g.apply((ListChannelMembershipsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private String channelArn;
        private List<ChannelMembershipSummary> channelMemberships = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelMembershipsResponse model) {
            super(model);
            this.channelArn(model.channelArn);
            this.channelMemberships(model.channelMemberships);
            this.nextToken(model.nextToken);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final List<ChannelMembershipSummary.Builder> getChannelMemberships() {
            List<ChannelMembershipSummary.Builder> result = ChannelMembershipSummaryListCopier.copyToBuilder(this.channelMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelMemberships(Collection<ChannelMembershipSummary.BuilderImpl> channelMemberships) {
            this.channelMemberships = ChannelMembershipSummaryListCopier.copyFromBuilder(channelMemberships);
        }

        @Override
        public final Builder channelMemberships(Collection<ChannelMembershipSummary> channelMemberships) {
            this.channelMemberships = ChannelMembershipSummaryListCopier.copy(channelMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMemberships(ChannelMembershipSummary ... channelMemberships) {
            this.channelMemberships(Arrays.asList(channelMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMemberships(Consumer<ChannelMembershipSummary.Builder> ... channelMemberships) {
            this.channelMemberships(Stream.of(channelMemberships).map(c -> (ChannelMembershipSummary)((ChannelMembershipSummary.Builder)ChannelMembershipSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChannelMembershipsResponse build() {
            return new ListChannelMembershipsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChannelMembershipsResponse> {
        public Builder channelArn(String var1);

        public Builder channelMemberships(Collection<ChannelMembershipSummary> var1);

        public Builder channelMemberships(ChannelMembershipSummary ... var1);

        public Builder channelMemberships(Consumer<ChannelMembershipSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

