/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.VoiceConnectorItem;
import software.amazon.awssdk.services.chime.model.VoiceConnectorItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVoiceConnectorGroupRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, UpdateVoiceConnectorGroupRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceConnectorGroupId").getter(UpdateVoiceConnectorGroupRequest.getter(UpdateVoiceConnectorGroupRequest::voiceConnectorGroupId)).setter(UpdateVoiceConnectorGroupRequest.setter(Builder::voiceConnectorGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorGroupId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateVoiceConnectorGroupRequest.getter(UpdateVoiceConnectorGroupRequest::name)).setter(UpdateVoiceConnectorGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<VoiceConnectorItem>> VOICE_CONNECTOR_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VoiceConnectorItems").getter(UpdateVoiceConnectorGroupRequest.getter(UpdateVoiceConnectorGroupRequest::voiceConnectorItems)).setter(UpdateVoiceConnectorGroupRequest.setter(Builder::voiceConnectorItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VoiceConnectorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_GROUP_ID_FIELD, NAME_FIELD, VOICE_CONNECTOR_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("voiceConnectorGroupId", VOICE_CONNECTOR_GROUP_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("VoiceConnectorItems", VOICE_CONNECTOR_ITEMS_FIELD);
        }
    });
    private final String voiceConnectorGroupId;
    private final String name;
    private final List<VoiceConnectorItem> voiceConnectorItems;

    private UpdateVoiceConnectorGroupRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorGroupId = builder.voiceConnectorGroupId;
        this.name = builder.name;
        this.voiceConnectorItems = builder.voiceConnectorItems;
    }

    public final String voiceConnectorGroupId() {
        return this.voiceConnectorGroupId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasVoiceConnectorItems() {
        return this.voiceConnectorItems != null && !(this.voiceConnectorItems instanceof SdkAutoConstructList);
    }

    public final List<VoiceConnectorItem> voiceConnectorItems() {
        return this.voiceConnectorItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVoiceConnectorItems() ? this.voiceConnectorItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVoiceConnectorGroupRequest)) {
            return false;
        }
        UpdateVoiceConnectorGroupRequest other = (UpdateVoiceConnectorGroupRequest)((Object)obj);
        return Objects.equals(this.voiceConnectorGroupId(), other.voiceConnectorGroupId()) && Objects.equals(this.name(), other.name()) && this.hasVoiceConnectorItems() == other.hasVoiceConnectorItems() && Objects.equals(this.voiceConnectorItems(), other.voiceConnectorItems());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVoiceConnectorGroupRequest").add("VoiceConnectorGroupId", (Object)this.voiceConnectorGroupId()).add("Name", (Object)this.name()).add("VoiceConnectorItems", this.hasVoiceConnectorItems() ? this.voiceConnectorItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorGroupId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorGroupId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "VoiceConnectorItems": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVoiceConnectorGroupRequest, T> g) {
        return obj -> g.apply((UpdateVoiceConnectorGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String voiceConnectorGroupId;
        private String name;
        private List<VoiceConnectorItem> voiceConnectorItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVoiceConnectorGroupRequest model) {
            super(model);
            this.voiceConnectorGroupId(model.voiceConnectorGroupId);
            this.name(model.name);
            this.voiceConnectorItems(model.voiceConnectorItems);
        }

        public final String getVoiceConnectorGroupId() {
            return this.voiceConnectorGroupId;
        }

        public final void setVoiceConnectorGroupId(String voiceConnectorGroupId) {
            this.voiceConnectorGroupId = voiceConnectorGroupId;
        }

        @Override
        public final Builder voiceConnectorGroupId(String voiceConnectorGroupId) {
            this.voiceConnectorGroupId = voiceConnectorGroupId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<VoiceConnectorItem.Builder> getVoiceConnectorItems() {
            List<VoiceConnectorItem.Builder> result = VoiceConnectorItemListCopier.copyToBuilder(this.voiceConnectorItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVoiceConnectorItems(Collection<VoiceConnectorItem.BuilderImpl> voiceConnectorItems) {
            this.voiceConnectorItems = VoiceConnectorItemListCopier.copyFromBuilder(voiceConnectorItems);
        }

        @Override
        public final Builder voiceConnectorItems(Collection<VoiceConnectorItem> voiceConnectorItems) {
            this.voiceConnectorItems = VoiceConnectorItemListCopier.copy(voiceConnectorItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceConnectorItems(VoiceConnectorItem ... voiceConnectorItems) {
            this.voiceConnectorItems(Arrays.asList(voiceConnectorItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceConnectorItems(Consumer<VoiceConnectorItem.Builder> ... voiceConnectorItems) {
            this.voiceConnectorItems(Stream.of(voiceConnectorItems).map(c -> (VoiceConnectorItem)((VoiceConnectorItem.Builder)VoiceConnectorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVoiceConnectorGroupRequest build() {
            return new UpdateVoiceConnectorGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVoiceConnectorGroupRequest> {
        public Builder voiceConnectorGroupId(String var1);

        public Builder name(String var1);

        public Builder voiceConnectorItems(Collection<VoiceConnectorItem> var1);

        public Builder voiceConnectorItems(VoiceConnectorItem ... var1);

        public Builder voiceConnectorItems(Consumer<VoiceConnectorItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

