/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidateE911AddressRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, ValidateE911AddressRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(ValidateE911AddressRequest.getter(ValidateE911AddressRequest::awsAccountId)).setter(ValidateE911AddressRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> STREET_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreetNumber").getter(ValidateE911AddressRequest.getter(ValidateE911AddressRequest::streetNumber)).setter(ValidateE911AddressRequest.setter(Builder::streetNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreetNumber").build()}).build();
    private static final SdkField<String> STREET_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreetInfo").getter(ValidateE911AddressRequest.getter(ValidateE911AddressRequest::streetInfo)).setter(ValidateE911AddressRequest.setter(Builder::streetInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreetInfo").build()}).build();
    private static final SdkField<String> CITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("City").getter(ValidateE911AddressRequest.getter(ValidateE911AddressRequest::city)).setter(ValidateE911AddressRequest.setter(Builder::city)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ValidateE911AddressRequest.getter(ValidateE911AddressRequest::state)).setter(ValidateE911AddressRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(ValidateE911AddressRequest.getter(ValidateE911AddressRequest::country)).setter(ValidateE911AddressRequest.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostalCode").getter(ValidateE911AddressRequest.getter(ValidateE911AddressRequest::postalCode)).setter(ValidateE911AddressRequest.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, STREET_NUMBER_FIELD, STREET_INFO_FIELD, CITY_FIELD, STATE_FIELD, COUNTRY_FIELD, POSTAL_CODE_FIELD));
    private final String awsAccountId;
    private final String streetNumber;
    private final String streetInfo;
    private final String city;
    private final String state;
    private final String country;
    private final String postalCode;

    private ValidateE911AddressRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.streetNumber = builder.streetNumber;
        this.streetInfo = builder.streetInfo;
        this.city = builder.city;
        this.state = builder.state;
        this.country = builder.country;
        this.postalCode = builder.postalCode;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String streetNumber() {
        return this.streetNumber;
    }

    public final String streetInfo() {
        return this.streetInfo;
    }

    public final String city() {
        return this.city;
    }

    public final String state() {
        return this.state;
    }

    public final String country() {
        return this.country;
    }

    public final String postalCode() {
        return this.postalCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.streetNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.streetInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateE911AddressRequest)) {
            return false;
        }
        ValidateE911AddressRequest other = (ValidateE911AddressRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.streetNumber(), other.streetNumber()) && Objects.equals(this.streetInfo(), other.streetInfo()) && Objects.equals(this.city(), other.city()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.postalCode(), other.postalCode());
    }

    public final String toString() {
        return ToString.builder((String)"ValidateE911AddressRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("StreetNumber", (Object)(this.streetNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("StreetInfo", (Object)(this.streetInfo() == null ? null : "*** Sensitive Data Redacted ***")).add("City", (Object)(this.city() == null ? null : "*** Sensitive Data Redacted ***")).add("State", (Object)(this.state() == null ? null : "*** Sensitive Data Redacted ***")).add("Country", (Object)(this.country() == null ? null : "*** Sensitive Data Redacted ***")).add("PostalCode", (Object)(this.postalCode() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "StreetNumber": {
                return Optional.ofNullable(clazz.cast(this.streetNumber()));
            }
            case "StreetInfo": {
                return Optional.ofNullable(clazz.cast(this.streetInfo()));
            }
            case "City": {
                return Optional.ofNullable(clazz.cast(this.city()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "PostalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateE911AddressRequest, T> g) {
        return obj -> g.apply((ValidateE911AddressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String streetNumber;
        private String streetInfo;
        private String city;
        private String state;
        private String country;
        private String postalCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateE911AddressRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.streetNumber(model.streetNumber);
            this.streetInfo(model.streetInfo);
            this.city(model.city);
            this.state(model.state);
            this.country(model.country);
            this.postalCode(model.postalCode);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getStreetNumber() {
            return this.streetNumber;
        }

        public final void setStreetNumber(String streetNumber) {
            this.streetNumber = streetNumber;
        }

        @Override
        public final Builder streetNumber(String streetNumber) {
            this.streetNumber = streetNumber;
            return this;
        }

        public final String getStreetInfo() {
            return this.streetInfo;
        }

        public final void setStreetInfo(String streetInfo) {
            this.streetInfo = streetInfo;
        }

        @Override
        public final Builder streetInfo(String streetInfo) {
            this.streetInfo = streetInfo;
            return this;
        }

        public final String getCity() {
            return this.city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ValidateE911AddressRequest build() {
            return new ValidateE911AddressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ValidateE911AddressRequest> {
        public Builder awsAccountId(String var1);

        public Builder streetNumber(String var1);

        public Builder streetInfo(String var1);

        public Builder city(String var1);

        public Builder state(String var1);

        public Builder country(String var1);

        public Builder postalCode(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

