/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.SipRuleTargetApplication;
import software.amazon.awssdk.services.chime.model.SipRuleTargetApplicationListCopier;
import software.amazon.awssdk.services.chime.model.SipRuleTriggerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SipRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SipRule> {
    private static final SdkField<String> SIP_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SipRuleId").getter(SipRule.getter(SipRule::sipRuleId)).setter(SipRule.setter(Builder::sipRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipRuleId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SipRule.getter(SipRule::name)).setter(SipRule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Disabled").getter(SipRule.getter(SipRule::disabled)).setter(SipRule.setter(Builder::disabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()}).build();
    private static final SdkField<String> TRIGGER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TriggerType").getter(SipRule.getter(SipRule::triggerTypeAsString)).setter(SipRule.setter(Builder::triggerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerType").build()}).build();
    private static final SdkField<String> TRIGGER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TriggerValue").getter(SipRule.getter(SipRule::triggerValue)).setter(SipRule.setter(Builder::triggerValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerValue").build()}).build();
    private static final SdkField<List<SipRuleTargetApplication>> TARGET_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetApplications").getter(SipRule.getter(SipRule::targetApplications)).setter(SipRule.setter(Builder::targetApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SipRuleTargetApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(SipRule.getter(SipRule::createdTimestamp)).setter(SipRule.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(SipRule.getter(SipRule::updatedTimestamp)).setter(SipRule.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIP_RULE_ID_FIELD, NAME_FIELD, DISABLED_FIELD, TRIGGER_TYPE_FIELD, TRIGGER_VALUE_FIELD, TARGET_APPLICATIONS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sipRuleId;
    private final String name;
    private final Boolean disabled;
    private final String triggerType;
    private final String triggerValue;
    private final List<SipRuleTargetApplication> targetApplications;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;

    private SipRule(BuilderImpl builder) {
        this.sipRuleId = builder.sipRuleId;
        this.name = builder.name;
        this.disabled = builder.disabled;
        this.triggerType = builder.triggerType;
        this.triggerValue = builder.triggerValue;
        this.targetApplications = builder.targetApplications;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    public final String sipRuleId() {
        return this.sipRuleId;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean disabled() {
        return this.disabled;
    }

    public final SipRuleTriggerType triggerType() {
        return SipRuleTriggerType.fromValue(this.triggerType);
    }

    public final String triggerTypeAsString() {
        return this.triggerType;
    }

    public final String triggerValue() {
        return this.triggerValue;
    }

    public final boolean hasTargetApplications() {
        return this.targetApplications != null && !(this.targetApplications instanceof SdkAutoConstructList);
    }

    public final List<SipRuleTargetApplication> targetApplications() {
        return this.targetApplications;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sipRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetApplications() ? this.targetApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SipRule)) {
            return false;
        }
        SipRule other = (SipRule)obj;
        return Objects.equals(this.sipRuleId(), other.sipRuleId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.disabled(), other.disabled()) && Objects.equals(this.triggerTypeAsString(), other.triggerTypeAsString()) && Objects.equals(this.triggerValue(), other.triggerValue()) && this.hasTargetApplications() == other.hasTargetApplications() && Objects.equals(this.targetApplications(), other.targetApplications()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"SipRule").add("SipRuleId", (Object)this.sipRuleId()).add("Name", (Object)this.name()).add("Disabled", (Object)this.disabled()).add("TriggerType", (Object)this.triggerTypeAsString()).add("TriggerValue", (Object)this.triggerValue()).add("TargetApplications", this.hasTargetApplications() ? this.targetApplications() : null).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SipRuleId": {
                return Optional.ofNullable(clazz.cast(this.sipRuleId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Disabled": {
                return Optional.ofNullable(clazz.cast(this.disabled()));
            }
            case "TriggerType": {
                return Optional.ofNullable(clazz.cast(this.triggerTypeAsString()));
            }
            case "TriggerValue": {
                return Optional.ofNullable(clazz.cast(this.triggerValue()));
            }
            case "TargetApplications": {
                return Optional.ofNullable(clazz.cast(this.targetApplications()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SipRule, T> g) {
        return obj -> g.apply((SipRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sipRuleId;
        private String name;
        private Boolean disabled;
        private String triggerType;
        private String triggerValue;
        private List<SipRuleTargetApplication> targetApplications = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTimestamp;
        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SipRule model) {
            this.sipRuleId(model.sipRuleId);
            this.name(model.name);
            this.disabled(model.disabled);
            this.triggerType(model.triggerType);
            this.triggerValue(model.triggerValue);
            this.targetApplications(model.targetApplications);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
        }

        public final String getSipRuleId() {
            return this.sipRuleId;
        }

        public final void setSipRuleId(String sipRuleId) {
            this.sipRuleId = sipRuleId;
        }

        @Override
        public final Builder sipRuleId(String sipRuleId) {
            this.sipRuleId = sipRuleId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getDisabled() {
            return this.disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final String getTriggerType() {
            return this.triggerType;
        }

        public final void setTriggerType(String triggerType) {
            this.triggerType = triggerType;
        }

        @Override
        public final Builder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        @Override
        public final Builder triggerType(SipRuleTriggerType triggerType) {
            this.triggerType(triggerType == null ? null : triggerType.toString());
            return this;
        }

        public final String getTriggerValue() {
            return this.triggerValue;
        }

        public final void setTriggerValue(String triggerValue) {
            this.triggerValue = triggerValue;
        }

        @Override
        public final Builder triggerValue(String triggerValue) {
            this.triggerValue = triggerValue;
            return this;
        }

        public final List<SipRuleTargetApplication.Builder> getTargetApplications() {
            List<SipRuleTargetApplication.Builder> result = SipRuleTargetApplicationListCopier.copyToBuilder(this.targetApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetApplications(Collection<SipRuleTargetApplication.BuilderImpl> targetApplications) {
            this.targetApplications = SipRuleTargetApplicationListCopier.copyFromBuilder(targetApplications);
        }

        @Override
        public final Builder targetApplications(Collection<SipRuleTargetApplication> targetApplications) {
            this.targetApplications = SipRuleTargetApplicationListCopier.copy(targetApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetApplications(SipRuleTargetApplication ... targetApplications) {
            this.targetApplications(Arrays.asList(targetApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetApplications(Consumer<SipRuleTargetApplication.Builder> ... targetApplications) {
            this.targetApplications(Stream.of(targetApplications).map(c -> (SipRuleTargetApplication)((SipRuleTargetApplication.Builder)SipRuleTargetApplication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public SipRule build() {
            return new SipRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SipRule> {
        public Builder sipRuleId(String var1);

        public Builder name(String var1);

        public Builder disabled(Boolean var1);

        public Builder triggerType(String var1);

        public Builder triggerType(SipRuleTriggerType var1);

        public Builder triggerValue(String var1);

        public Builder targetApplications(Collection<SipRuleTargetApplication> var1);

        public Builder targetApplications(SipRuleTargetApplication ... var1);

        public Builder targetApplications(Consumer<SipRuleTargetApplication.Builder> ... var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);
    }
}

