/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.chime.ChimeAsyncClient;
import software.amazon.awssdk.services.chime.ChimeAsyncClientBuilder;
import software.amazon.awssdk.services.chime.ChimeServiceClientConfiguration;
import software.amazon.awssdk.services.chime.DefaultChimeAsyncClient;
import software.amazon.awssdk.services.chime.DefaultChimeBaseClientBuilder;
import software.amazon.awssdk.services.chime.endpoints.ChimeEndpointProvider;

@SdkInternalApi
final class DefaultChimeAsyncClientBuilder
extends DefaultChimeBaseClientBuilder<ChimeAsyncClientBuilder, ChimeAsyncClient>
implements ChimeAsyncClientBuilder {
    DefaultChimeAsyncClientBuilder() {
    }

    @Override
    public DefaultChimeAsyncClientBuilder endpointProvider(ChimeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ChimeAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultChimeAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ChimeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultChimeAsyncClient client = new DefaultChimeAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ChimeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ChimeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

