/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeChannelMembershipForAppInstanceUserResponse extends ChimeResponse
        implements
        ToCopyableBuilder<DescribeChannelMembershipForAppInstanceUserResponse.Builder, DescribeChannelMembershipForAppInstanceUserResponse> {
    private static final SdkField<ChannelMembershipForAppInstanceUserSummary> CHANNEL_MEMBERSHIP_FIELD = SdkField
            .<ChannelMembershipForAppInstanceUserSummary> builder(MarshallingType.SDK_POJO).memberName("ChannelMembership")
            .getter(getter(DescribeChannelMembershipForAppInstanceUserResponse::channelMembership))
            .setter(setter(Builder::channelMembership)).constructor(ChannelMembershipForAppInstanceUserSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelMembership").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_MEMBERSHIP_FIELD));

    private final ChannelMembershipForAppInstanceUserSummary channelMembership;

    private DescribeChannelMembershipForAppInstanceUserResponse(BuilderImpl builder) {
        super(builder);
        this.channelMembership = builder.channelMembership;
    }

    /**
     * <p>
     * The channel to which a user belongs.
     * </p>
     * 
     * @return The channel to which a user belongs.
     */
    public final ChannelMembershipForAppInstanceUserSummary channelMembership() {
        return channelMembership;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelMembership());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChannelMembershipForAppInstanceUserResponse)) {
            return false;
        }
        DescribeChannelMembershipForAppInstanceUserResponse other = (DescribeChannelMembershipForAppInstanceUserResponse) obj;
        return Objects.equals(channelMembership(), other.channelMembership());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeChannelMembershipForAppInstanceUserResponse")
                .add("ChannelMembership", channelMembership()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelMembership":
            return Optional.ofNullable(clazz.cast(channelMembership()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeChannelMembershipForAppInstanceUserResponse, T> g) {
        return obj -> g.apply((DescribeChannelMembershipForAppInstanceUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeChannelMembershipForAppInstanceUserResponse> {
        /**
         * <p>
         * The channel to which a user belongs.
         * </p>
         * 
         * @param channelMembership
         *        The channel to which a user belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMembership(ChannelMembershipForAppInstanceUserSummary channelMembership);

        /**
         * <p>
         * The channel to which a user belongs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ChannelMembershipForAppInstanceUserSummary.Builder} avoiding the need to create one manually via
         * {@link ChannelMembershipForAppInstanceUserSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelMembershipForAppInstanceUserSummary.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #channelMembership(ChannelMembershipForAppInstanceUserSummary)}.
         * 
         * @param channelMembership
         *        a consumer that will call methods on {@link ChannelMembershipForAppInstanceUserSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelMembership(ChannelMembershipForAppInstanceUserSummary)
         */
        default Builder channelMembership(Consumer<ChannelMembershipForAppInstanceUserSummary.Builder> channelMembership) {
            return channelMembership(ChannelMembershipForAppInstanceUserSummary.builder().applyMutation(channelMembership)
                    .build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private ChannelMembershipForAppInstanceUserSummary channelMembership;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChannelMembershipForAppInstanceUserResponse model) {
            super(model);
            channelMembership(model.channelMembership);
        }

        public final ChannelMembershipForAppInstanceUserSummary.Builder getChannelMembership() {
            return channelMembership != null ? channelMembership.toBuilder() : null;
        }

        public final void setChannelMembership(ChannelMembershipForAppInstanceUserSummary.BuilderImpl channelMembership) {
            this.channelMembership = channelMembership != null ? channelMembership.build() : null;
        }

        @Override
        public final Builder channelMembership(ChannelMembershipForAppInstanceUserSummary channelMembership) {
            this.channelMembership = channelMembership;
            return this;
        }

        @Override
        public DescribeChannelMembershipForAppInstanceUserResponse build() {
            return new DescribeChannelMembershipForAppInstanceUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
