/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMeetingRequest extends ChimeRequest implements
        ToCopyableBuilder<CreateMeetingRequest.Builder, CreateMeetingRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateMeetingRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> EXTERNAL_MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalMeetingId").getter(getter(CreateMeetingRequest::externalMeetingId))
            .setter(setter(Builder::externalMeetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalMeetingId").build()).build();

    private static final SdkField<String> MEETING_HOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeetingHostId").getter(getter(CreateMeetingRequest::meetingHostId))
            .setter(setter(Builder::meetingHostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingHostId").build()).build();

    private static final SdkField<String> MEDIA_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaRegion").getter(getter(CreateMeetingRequest::mediaRegion)).setter(setter(Builder::mediaRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaRegion").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateMeetingRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MeetingNotificationConfiguration> NOTIFICATIONS_CONFIGURATION_FIELD = SdkField
            .<MeetingNotificationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("NotificationsConfiguration")
            .getter(getter(CreateMeetingRequest::notificationsConfiguration))
            .setter(setter(Builder::notificationsConfiguration))
            .constructor(MeetingNotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationsConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            EXTERNAL_MEETING_ID_FIELD, MEETING_HOST_ID_FIELD, MEDIA_REGION_FIELD, TAGS_FIELD, NOTIFICATIONS_CONFIGURATION_FIELD));

    private final String clientRequestToken;

    private final String externalMeetingId;

    private final String meetingHostId;

    private final String mediaRegion;

    private final List<Tag> tags;

    private final MeetingNotificationConfiguration notificationsConfiguration;

    private CreateMeetingRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.externalMeetingId = builder.externalMeetingId;
        this.meetingHostId = builder.meetingHostId;
        this.mediaRegion = builder.mediaRegion;
        this.tags = builder.tags;
        this.notificationsConfiguration = builder.notificationsConfiguration;
    }

    /**
     * <p>
     * The unique identifier for the client request. Use a different token for different meetings.
     * </p>
     * 
     * @return The unique identifier for the client request. Use a different token for different meetings.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The external meeting ID.
     * </p>
     * 
     * @return The external meeting ID.
     */
    public final String externalMeetingId() {
        return externalMeetingId;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String meetingHostId() {
        return meetingHostId;
    }

    /**
     * <p>
     * The Region in which to create the meeting. Default: <code>us-east-1</code>.
     * </p>
     * <p>
     * Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> ,
     * <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> ,
     * <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> ,
     * <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> ,
     * <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> .
     * </p>
     * 
     * @return The Region in which to create the meeting. Default: <code>us-east-1</code>. </p>
     *         <p>
     *         Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> ,
     *         <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> ,
     *         <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code>
     *         , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> ,
     *         <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> .
     */
    public final String mediaRegion() {
        return mediaRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag key-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag key-value pairs.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration for resource targets to receive notifications when meeting and attendee events occur.
     * </p>
     * 
     * @return The configuration for resource targets to receive notifications when meeting and attendee events occur.
     */
    public final MeetingNotificationConfiguration notificationsConfiguration() {
        return notificationsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(externalMeetingId());
        hashCode = 31 * hashCode + Objects.hashCode(meetingHostId());
        hashCode = 31 * hashCode + Objects.hashCode(mediaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(notificationsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeetingRequest)) {
            return false;
        }
        CreateMeetingRequest other = (CreateMeetingRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(externalMeetingId(), other.externalMeetingId())
                && Objects.equals(meetingHostId(), other.meetingHostId()) && Objects.equals(mediaRegion(), other.mediaRegion())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(notificationsConfiguration(), other.notificationsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMeetingRequest")
                .add("ClientRequestToken", clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExternalMeetingId", externalMeetingId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MeetingHostId", meetingHostId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MediaRegion", mediaRegion()).add("Tags", hasTags() ? tags() : null)
                .add("NotificationsConfiguration", notificationsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "ExternalMeetingId":
            return Optional.ofNullable(clazz.cast(externalMeetingId()));
        case "MeetingHostId":
            return Optional.ofNullable(clazz.cast(meetingHostId()));
        case "MediaRegion":
            return Optional.ofNullable(clazz.cast(mediaRegion()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "NotificationsConfiguration":
            return Optional.ofNullable(clazz.cast(notificationsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMeetingRequest, T> g) {
        return obj -> g.apply((CreateMeetingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMeetingRequest> {
        /**
         * <p>
         * The unique identifier for the client request. Use a different token for different meetings.
         * </p>
         * 
         * @param clientRequestToken
         *        The unique identifier for the client request. Use a different token for different meetings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The external meeting ID.
         * </p>
         * 
         * @param externalMeetingId
         *        The external meeting ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalMeetingId(String externalMeetingId);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param meetingHostId
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingHostId(String meetingHostId);

        /**
         * <p>
         * The Region in which to create the meeting. Default: <code>us-east-1</code>.
         * </p>
         * <p>
         * Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> ,
         * <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> ,
         * <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> ,
         * <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> ,
         * <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> .
         * </p>
         * 
         * @param mediaRegion
         *        The Region in which to create the meeting. Default: <code>us-east-1</code>. </p>
         *        <p>
         *        Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code>
         *        , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> ,
         *        <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> ,
         *        <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> ,
         *        <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> ,
         *        <code>us-west-2</code> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaRegion(String mediaRegion);

        /**
         * <p>
         * The tag key-value pairs.
         * </p>
         * 
         * @param tags
         *        The tag key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag key-value pairs.
         * </p>
         * 
         * @param tags
         *        The tag key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag key-value pairs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chime.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.chime.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.chime.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.chime.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The configuration for resource targets to receive notifications when meeting and attendee events occur.
         * </p>
         * 
         * @param notificationsConfiguration
         *        The configuration for resource targets to receive notifications when meeting and attendee events
         *        occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationsConfiguration(MeetingNotificationConfiguration notificationsConfiguration);

        /**
         * <p>
         * The configuration for resource targets to receive notifications when meeting and attendee events occur.
         * </p>
         * This is a convenience method that creates an instance of the {@link MeetingNotificationConfiguration.Builder}
         * avoiding the need to create one manually via {@link MeetingNotificationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeetingNotificationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #notificationsConfiguration(MeetingNotificationConfiguration)}.
         * 
         * @param notificationsConfiguration
         *        a consumer that will call methods on {@link MeetingNotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationsConfiguration(MeetingNotificationConfiguration)
         */
        default Builder notificationsConfiguration(Consumer<MeetingNotificationConfiguration.Builder> notificationsConfiguration) {
            return notificationsConfiguration(MeetingNotificationConfiguration.builder()
                    .applyMutation(notificationsConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String externalMeetingId;

        private String meetingHostId;

        private String mediaRegion;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private MeetingNotificationConfiguration notificationsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMeetingRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            externalMeetingId(model.externalMeetingId);
            meetingHostId(model.meetingHostId);
            mediaRegion(model.mediaRegion);
            tags(model.tags);
            notificationsConfiguration(model.notificationsConfiguration);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getExternalMeetingId() {
            return externalMeetingId;
        }

        public final void setExternalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
        }

        @Override
        public final Builder externalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
            return this;
        }

        public final String getMeetingHostId() {
            return meetingHostId;
        }

        public final void setMeetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
        }

        @Override
        public final Builder meetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
            return this;
        }

        public final String getMediaRegion() {
            return mediaRegion;
        }

        public final void setMediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
        }

        @Override
        public final Builder mediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = MeetingTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = MeetingTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = MeetingTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MeetingNotificationConfiguration.Builder getNotificationsConfiguration() {
            return notificationsConfiguration != null ? notificationsConfiguration.toBuilder() : null;
        }

        public final void setNotificationsConfiguration(MeetingNotificationConfiguration.BuilderImpl notificationsConfiguration) {
            this.notificationsConfiguration = notificationsConfiguration != null ? notificationsConfiguration.build() : null;
        }

        @Override
        public final Builder notificationsConfiguration(MeetingNotificationConfiguration notificationsConfiguration) {
            this.notificationsConfiguration = notificationsConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMeetingRequest build() {
            return new CreateMeetingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
